#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>





typedef struct {
  PerlInterpreter *interp;    /* The threads interpreter */
  SV* thread_function_start;  /* A ref to a CV for our init function */
  SV* init_params;            /* A ref to an AV with our params */
  pthread_t tid;              /* Our thread */
  pthread_mutex_t *mutex;     /* Our mutex */
  int active;                 /* Is this thread active? */
  int detached;               /* Is it detached? */
  int clean;	               /* Have we done cleanup? */
} myperl_iThread;



static pthread_mutex_t create_mutex = PTHREAD_MUTEX_INITIALIZER;
PerlInterpreter *shared_sv_space;   /* use for shared variables */
PerlInterpreter *first_interpreter;

static pthread_mutex_t thread_list_mutex = PTHREAD_MUTEX_INITIALIZER;
HV* hv_threads;


/* internal functions */
void ithread_execute (myperl_iThread* thread);
void ithread_run(myperl_iThread* thread);


/* Perl mapped functions to iThread:: */
SV* ithread_create(char* class, SV* function_to_call, SV* params);
int ithread_tid (SV* obj);
void ithread_join(SV* obj);
void ithread_detach(SV* obj);



/* iThread::Shared thingies 

The struct contains an SV, an mutex and condition.

The reference count of the SV is the amount of threads referencing the SV, when that count drops to zero we destroy ourselves.

The individual per thread refcount is controlled by the perthread access object, which is just a normal SV pointing to this one.

*/

typedef struct {
  SV* sv;
  pthread_mutex_t *lock;
  pthread_cond_t  *cond;
} ithread_shared_sv;

SV* ithread_shared_sv__new(char* class);  /* base object constructor */
SV* ithread_shared_sv_new(char* class);   /* creates a sv */
SV* ithread_shared_av_new(char* class);   /* creates an av */
SV* ithread_shared_hv_new(char* class);   /* creates an hv */
void ithread_shared_sv_set(SV* obj, SV* value); /* sets the underlaying SV */
SV*  ithread_shared_sv_get(SV* obj);            /* returns a copy of the SV */
SV*  ithread_shared_sv_ref(SV* obj);            /* returns a ref to the SV */
void ithread_shared_sv_refinc(SV* obj);
void ithread_shared_sv_refdec(SV* obj);
void ithread_shared_sv_lock(SV* obj);
void ithread_shared_sv_unlock(SV* obj);
void ithread_shared_sv_cond_wait(SV* obj);
void ithread_shared_sv_cond_signal(SV* obj);
void ithread_shared_sv_cond_broadcast(SV* obj);

const char* ithread_shared_sv_class = "iThread::Shared::SV";
const char* ithread_shared_av_class = "iThread::Shared::AV";
const char* ithread_shared_hv_class = "iThread::Shared::HV";




