
package iThread::Safe;
use iThread;
use iThread::Shared;

require Exporter;
our @ISA = 'Exporter';
use vars qw(@EXPORT);
@EXPORT = qw(localtime gmtime rand);

use strict;

sub import {
    my $pkg = shift;
    @_ = (@_, @EXPORT);
    return unless @_;
    my $where = "CORE::GLOBAL";
    $pkg->export($where, @_);
}


{
    my $mutex : shared;
    sub localtime  {
	my $lock = lock($mutex);
      CORE::localtime(@_);
    } 
}

{
    my $mutex : shared;
    sub gmtime {
	my $lock = lock($mutex);
      CORE::gmtime(@_);
    }
}

{ 
    my $mutex : shared;
    sub rand {
	my $lock = lock($mutex);
      CORE::rand(@_);
    }
1;
    









