package Devel::Internals;

use strict;
use warnings;

require Exporter;
require DynaLoader;

use vars qw(@ISA @EXPORT $VERSION);
@ISA     = qw(Exporter DynaLoader);
@EXPORT  = qw(sbrk MemUsed); 
$VERSION = "0.01";

bootstrap Devel::Internals;

my @brk = (Devel::Internals::sbrk ());

sub MemUsed (;$)
{
    my ($msg) = (@_, "");
    push @brk, Devel::Internals::sbrk ();
    my $num = $brk[-1] - $brk[-2];
    my $wa = wantarray;
    if (defined $wa) {
	$a and return @brk;
	return $num;
	}
    $num =~ s/(^[-+]?\d+?(?=(?>(?:\d{3})+)(?!\d))|\G\d{3}(?=\d))/$1./g;
    print STDERR "Used %14s bytes to %s\n", $num, $msg;
    } # MemUsed

1;
__END__

=head1 NAME

Devel-Internals - Perl extension for internal interpreter statistics

=head1 SYNOPSIS

  use Devel::Internals;

  my $end = sbrk ();

  my @array = (1..10000);
  print "The creation of this array used ",
      sbrk () - $end, "bytes\n";

  # Easier
  use Devel::Internals;

  my @array = (1..10000);
  MemUsed "creation of array";

  my @dup = @array;
  MemUsed "duplication of array";

=head1 DESCRIPTION

=over 4

=item sbrk

returns the current memory top. See sbrk(2) manual page

=item MemUsed ($msg)

Used in void context reports the number of bytes used since the
previous call to MemUsed with the message passed

Used in scalar context returns the current sbrk value

Used in list context returns the values saved on every call

=back

=head1 AUTHOR

H.Merijn Brand <h.m.brand@procura.nl>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 1996-2002 H.Merijn Brand for PROCURA B.V.

This library is free software; you can use it under the
same terms as Perl itself

=head1 SEE ALSO

sbrk(2)

=cut
