=head1 Information
Author: Jason Plum (mage@cca95.org)
Date:	11/18/2005

More information on how this was created: (long url)
http://msdn.microsoft.com/library/default.asp?url=/library/en-us/shellcc/platform/shell/programmersguide/shell_int/shell_int_programming/appbars.asp
=cut

package Win32::GUI::Window::AppBar;
use strict;
use warnings;
#use Switch;
#TODO: get proper inc dirs and subclassing...if needed..
use Win32::API;
use Win32::GUI;

our $DEBUG = 1;
our $VERSION = '0.1';
my %Options;



sub DebugMsg {
	if( $DEBUG ){
		print @_ ;
	}
}



#==========
# Constants
use constant {
	NULL	=> undef,
     CX_DEFWIDTH		=> 50,
     CY_DEFHEIGHT		=> 50,
     IDT_AUTOHIDE		=> 1,
     IDT_AUTOUNHIDE		=> 2,
     ABM_NEW           => 0x00000000,
     ABM_REMOVE        => 0x00000001,
     ABM_QUERYPOS      => 0x00000002,
     ABM_SETPOS        => 0x00000003,
     ABM_GETSTATE      => 0x00000004,
     ABM_GETTASKBARPOS => 0x00000005,
     ABM_ACTIVATE      => 0x00000006,  
     ABM_GETAUTOHIDEBAR=> 0x00000007,
     ABM_SETAUTOHIDEBAR=> 0x00000008,  
     ABM_WINDOWPOSCHANGED=> 0x0000009,
     ABM_SETSTATE      	=> 0x0000000a,
     ABN_STATECHANGE    => 0x0000000,
     ABN_POSCHANGED     => 0x0000001,
     ABN_FULLSCREENAPP  => 0x0000002,
     ABN_WINDOWARRANGE  => 0x0000003, 
	ABS_AUTOHIDE    => 0x0000001,
	ABS_ALWAYSONTOP => 0x0000002,
	ABE_LEFT        => 0,
	ABE_TOP         => 1,
	ABE_RIGHT       => 2,
	ABE_BOTTOM      => 3,
	WM_USER       	=> 0x0400,
	ABC_CALLBACK	=> (0x400 + 1010),
	HWND_TOPMOST 	=> -1,
	HWND_NOTOPMOST => -2,
	HWND_BOTTOM		=> 1,
	HWND_TOP		=> 0,
	SWP_NOSIZE		=> 1,
	SWP_NOMOVE     => 2,
	SWP_NOACTIVATE => 16,
	#define SWP_NOSIZE          0x0001
#define SWP_NOMOVE          0x0002
	SWP_NOZORDER    =>  0x0004,
#define SWP_NOREDRAW        0x0008
#define SWP_NOACTIVATE      0x0010
	SWP_FRAMECHANGED  =>  0x0020, #  /* The frame changed: send WM_NCCALCSIZE */
#define SWP_SHOWWINDOW      0x0040
#define SWP_HIDEWINDOW      0x0080
#define SWP_NOCOPYBITS      0x0100
#define SWP_NOOWNERZORDER   0x0200  /* Don't do owner Z ordering */
#define SWP_NOSENDCHANGING  0x0400  /* Don't send WM_WINDOWPOSCHANGING */
	SWP_DRAWFRAME     =>  0x0020,
#define SWP_NOREPOSITION    SWP_NOOWNERZORDER
	#WM_COMMAND => 273,#
	WM_NOTIFY	=> 78,
	#WM_ACTIVATE => 6,#
	WM_WINDOWPOSCHANGED => 0x47,
	#SM_CXSCREEN	=> 0,#
	#SM_CYSCREEN	=> 1,#
	#GW_HWNDPREV	=> 3,#
	#GW_OWNER 		=> 4,#
	RDW_INVALIDATE	  => 0x001,
	RDW_ALLCHILDREN  => 0x080,
	RDW_UPDATENOW    => 0x100,
	g_dtSlideHide => 400,
	g_dtSlideShow => 200,
};


#=========
# Typedefs
print "Structs\n";
typedef Win32::API::Struct 'RECT' => qw(
	LONG left;
	LONG top;
	LONG right;
	LONG bottom;
);

typedef Win32::API::Struct 'APPBARDATA' => qw(
    DWORD cbSize;
    HWND hWnd;
    UINT uCallbackMessage;
    UINT uEdge;
    RECT rc;
    LPARAM lParam;
);

typedef Win32::API::Struct 'PAPPBARDATA' => '*APPBARDATA';

#=========
# Imports
Win32::API->Import(
	"shell32", "UINT_PTR SHAppBarMessage( DWORD dwMessage, PAPPBARDATA pData )",
);

Win32::API->Import(
	"user32", "BOOL OffsetRect( LPRECT lprc, int dx, int dy)"
);

Win32::API->Import(
	"kernel32", "DWORD GetTickCount()",
);

Win32::API->Import(
	"user32", 
	"BOOL SetWindowPos( HWND hWnd, HWND hWndInsertAfter, int X, int Y, int cx, int cy, UINT uFlags )"
);

Win32::API->Import(
	"user32",
	"BOOL MoveWindow(HWND hWnd,int X,int Y,int nWidth,int nHeight,BOOL bRepaint)"
);

Win32::API->Import(
	"user32",
	"BOOL RedrawWindow( HWND hWnd, RECT *lprcUpdate, HRGN hrgnUpdate, UINT flags);"
);

# Create Options data.
sub Prepare {
	my $hWnd = shift;
	DebugMsg "AppBar_Prepare ( $hWnd)\n";
	my %dump = (
		-AutoHide => 0,
		-Top	=> 0,
		-Side	=> ABE_TOP,
		-cxWidth => CX_DEFWIDTH,
		-cyHeight=> CY_DEFHEIGHT,
		zOrder => 0,
		_Registered => 0,
		Hiding	=> 0,
	);
	$Options{$hWnd} = \%dump;
	if( $DEBUG >= 2){
		use Data::Dump;
		DebugMsg "AppBar_Prepare : ",Data::Dump::dump($Options{$hWnd}),"\n";
	}
	return $Options{$hWnd};
}

#BOOL AppBar_Register(HWND hwnd);

sub Register{
	my $hWnd = shift;
	DebugMsg "AppBar_Register($hWnd)\n";
	my $abd = new Win32::API::Struct("APPBARDATA");
	$abd->{cbSize}=$abd->sizeof();
	$abd->{hWnd} = $hWnd;
	
	$abd->{uCallbackMessage} = ABC_CALLBACK;
	DebugMsg "AppBar_Register( sending message)\n";
	if( $DEBUG  >= 2){
		use Data::Dump;
		DebugMsg "AppBar_Register: ",Data::Dump::dump($Options{$hWnd}),"\n";
	}
	$Options{$hWnd}{_Registered} = SHAppBarMessage(ABM_NEW, $abd);
	if( $Options{$hWnd}{_Registered} ){
		#hook
		Win32::GUI::Hook($hWnd,ABC_CALLBACK,\&Callback);
		Win32::GUI::Hook($hWnd,WM_ACTIVATE, \&WindowActivate);
		Win32::GUI::Hook($hWnd,WM_WINDOWPOSCHANGED, \&WindowPosChanged);
	}
	return $Options{$hWnd}{_Registered};
}

#BOOL AppBar_UnRegister(HWND hwnd);

sub UnRegister {
	my $hWnd = shift;
	DebugMsg "AppBar_UnRegister($hWnd)\n";
	my $abd = new Win32::API::Struct("APPBARDATA");
	$abd->{cbSize}=$abd->sizeof();
	$abd->{hWnd} = $hWnd;

	$Options{$hWnd}{_Registered} = !SHAppBarMessage(ABM_REMOVE, $abd);
	if( !$Options{$hWnd}{_Registered} ){
		#unhook
		Win32::GUI::UnHook($hWnd,ABC_CALLBACK,\&Callback);
		Win32::GUI::UnHook($hWnd,WM_ACTIVATE, \&WindowActivate);
		Win32::GUI::UnHook($hWnd,WM_WINDOWPOSCHANGED, \&WindowPosChanged);
	}
	return $Options{$hWnd}{_Registered};
}

#void AppBar_Size(HWND);

sub Size{
	my $hWnd = shift;
	DebugMsg("AppBar_Size ($hWnd)\n");
	if( $Options{$hWnd}{_Registered} ){
		
		#my $hWnd = shift;
			
		my $abd = new Win32::API::Struct("APPBARDATA");
		$abd->{cbSize}=$abd->sizeof();
		$abd->{hWnd} = $hWnd;
		
		my $rc = new Win32::API::Struct("RECT");
		( $rc->{left}, $rc->{top}, $rc->{right}, $rc->{bottom} ) = Win32::GUI::GetWindowRect($hWnd);
		
		QuerySetPos( $Options{-Side}, $rc, $abd, 1);
	}
}

#void AppBar_QueryPos(HWND, LPRECT);
# return $rc!
sub QueryPos {
	my $hWnd = shift;
	my $rc = shift;
	DebugMsg "AppBar_QueryPos ($hWnd)\n";
	my $abd = new Win32::API::Struct("APPBARDATA");
	$abd->{cbSize}=$abd->sizeof();
	$abd->{hWnd} = $hWnd;
	
	#POPTIONS pOpt = GetAppbarData(hwnd);
	my $iWidth = 0;
	my $iHeight = 0;

	#// Fill out the APPBARDATA struct and save the edge we're moving to
	#// in the appbar OPTIONS struct.
	$abd->{rc} = $rc;
	$abd->{uEdge} = $Options{$hWnd}{-Side}; #pOpt->uSide;

	#// Calculate the part we want to occupy.  We only figure out the top
	#// and bottom coordinates if we're on the top or bottom of the screen.
	#// Likewise for the left and right.  We will always try to occupy the
	#// full height or width of the screen edge.
	if ((ABE_LEFT == $abd->{uEdge}) || (ABE_RIGHT == $abd->{uEdge}))
	{
		$iWidth = $abd->{rc}->{right} - $abd->{rc}->{left};
		$abd->{rc}->{top} = 0;
		$abd->{rc}->{bottom} = Win32::GUI::GetSystemMetrics(SM_CYSCREEN);
	}else{
		$iHeight = $abd->{rc}->{bottom} - $abd->{rc}->{top};
		$abd->{rc}->{left} = 0;
		$abd->{rc}->{right} = Win32::GUI::GetSystemMetrics(SM_CXSCREEN);
	}

	#// Ask the system for the screen space
	SHAppBarMessage(ABM_QUERYPOS, $abd);

	#// The system will return an approved position along the edge we're asking
	#// for.  However, if we can't get the exact position requested, the system
	#// only updates the edge that's incorrect.  For example, if we want to 
	#// attach to the bottom of the screen and the taskbar is already there, 
	#// we'll pass in a rect like 0, 964, 1280, 1024 and the system will return
	#// 0, 964, 1280, 996.  Since the appbar has to be above the taskbar, the 
	#// bottom of the rect was adjusted to 996.  We need to adjust the opposite
	#// edge of the rectangle to preserve the height we want.

	if($abd->{uEdge} == ABE_LEFT) {
		$abd->{rc}->{right} = $abd->{rc}->{left} + $iWidth;
	}
	if($abd->{uEdge} == ABE_RIGHT) {
		$abd->{rc}->{left} = $abd->{rc}->{right} - $iWidth;
	}
	if($abd->{uEdge} == ABE_TOP) {
		$abd->{rc}->{bottom} = $abd->{rc}->{top} + $iHeight;
	}
	if($abd->{uEdge} == ABE_BOTTOM) {
		$abd->{rc}->{top} = $abd->{rc}->{bottom} - $iHeight;
	}
	
	return $abd->{rc};
}

#void AppBar_QuerySetPos(UINT, LPRECT, PAPPBARDATA, BOOL);

sub QuerySetPos {
	my $uEdge = shift;
	my $rc = shift;
	my $abd = shift;
	my $fMove = shift;
	DebugMsg "AppBar_QuerySetPos ($uEdge,$fMove)\n";
	my $hWnd = $abd->{hWnd};
	
	my $iHeight = 0;
	my $iWidth = 0;
	#POPTIONS pOpt = GetAppbarData(pabd->hWnd);

	#DebugMsg("AppBarQuerySetPos: uEdge=%d, lprc->left=%d, lprc->top=%d, "
	#		 "lprc->right=%d, lprc->bottom=%d\r\n", uEdge, lprc->left,
	#		 lprc->top, lprc->right, lprc->bottom);

    #// Fill out the APPBARDATA struct and save the edge we're moving to
    #// in the appbar OPTIONS struct.
	$abd->{rc} = $rc;
	$abd->{uEdge} = $uEdge;
	
	$Options{$hWnd}{-Side} = $uEdge;

	$abd->{rc} = QueryPos($abd->{hWnd}, $abd->{rc});


    #// Tell the system we're moving to this new approved position.
	SHAppBarMessage(ABM_SETPOS, $abd);

	if ($fMove){
    	#// Move the appbar window to the new position
		MoveWindow($abd->{hWnd}, $abd->{rc}->{left}, $abd->{rc}->{top}, 
			   	   $abd->{rc}->{right} - $abd->{rc}->{left},
			   	   $abd->{rc}->{bottom} - $abd->{rc}->{top}, 1);
	}

    #// Save the appbar rect.  We use this later when we autohide.  If we're
	#// currently hidden, then don't mess with this.
	if (!$Options{$hWnd}{Hiding}){
		$Options{$hWnd}{Rect} = $abd->{rc};
	}

}

#void AppBar_PosChanged(PAPPBARDATA);

sub PosChanged{
	my $abd = shift;
    my $rc = new Win32::API::Struct('RECT');
    my $rcWindow = new Win32::API::Struct('RECT');
    my $iHeight;
    my $iWidth;
	my $hWnd = $abd->{hWnd};

	DebugMsg("AppBar_PosChanged\r\n");
    
    #// Start by getting the size of the screen.
    $rc->{top} = 0;
    $rc->{left} = 0;
    $rc->{right} = Win32::GUI::GetSystemMetrics(SM_CXSCREEN);
    $rc->{bottom} = Win32::GUI::GetSystemMetrics(SM_CYSCREEN);

	#// Update the g_rcAppbar so when we slide (if hidden) we slide to the 
	#// right place.
	if ($Options{$hWnd}{-AutoHide}){
		$Options{$hWnd}{Rect} = $rc;
		if($Options{$hWnd}{'-Side'} == ABE_TOP)   { $Options{$hWnd}{Rect}->{bottom} = $Options{$hWnd}{Rect}->{top}    + $Options{$hWnd}{-cyHeight}; }
		if($Options{$hWnd}{'-Side'} == ABE_BOTTOM){ $Options{$hWnd}{Rect}->{top}    = $Options{$hWnd}{Rect}->{bottom} - $Options{$hWnd}{-cyHeight}; }
		if($Options{$hWnd}{'-Side'} == ABE_LEFT)  { $Options{$hWnd}{Rect}->{right}  = $Options{$hWnd}{Rect}->{left}   + $Options{$hWnd}{-cxWidth};  }
		if($Options{$hWnd}{'-Side'} == ABE_RIGHT) { $Options{$hWnd}{Rect}->{left}   = $Options{$hWnd}{Rect}->{right}  - $Options{$hWnd}{-cxWidth};  } 		
	}		 

    #// Now get the current window rectangle and find the height and width
    ($rcWindow->{left}, $rcWindow->{top}, $rcWindow->{right}, $rcWindow->{bottom}) = Win32::GUI::GetWindowRect($hWnd);
    $iHeight = $rcWindow->{bottom} - $rcWindow->{top};
    $iWidth = $rcWindow->{right} - $rcWindow->{left};

    #// Depending on which side we're on, try to preserve the thickness of
    #// the window    
    # switch statement was bitching.. got rid of it.
	if( $Options{$hWnd}{'-Side'} == ABE_TOP)   { $rc->{bottom} = $rc->{top}    + $iHeight; };
	if( $Options{$hWnd}{'-Side'} == ABE_BOTTOM){ $rc->{top}    = $rc->{bottom} - $iHeight; };
	if( $Options{$hWnd}{'-Side'} == ABE_LEFT)  { $rc->{right}  = $rc->{left}   + $iWidth;  };
	if( $Options{$hWnd}{'-Side'} == ABE_RIGHT) { $rc->{left}   = $rc->{right}  - $iWidth;  };    

    #// Move the appbar.
    QuerySetPos($Options{$hWnd}{-Side}, $rc, $abd, 1);

}

#BOOL AppBar_SetAutoHide(HWND hwnd, BOOL fHide);

sub SetAutoHide{
	my $hwnd = shift;
	my $fHide = shift;
	DebugMsg "AppBar_SetAutoHide ($hwnd,$fHide)\n";
	if ($fHide){
		return AutoHide($hwnd);
	}else{
		return NoAutoHide($hwnd);
	}
}
=head 
OOL AppBar_AutoHide(HWND hwnd)
{
	HWND hwndAutoHide;
	APPBARDATA abd;
	POPTIONS pOpt = GetAppbarData(hwnd);
	BOOL fSuccess;	
	RECT rc;

	abd.cbSize = sizeof(APPBARDATA);
	abd.hWnd = hwnd;
	abd.uEdge = pOpt->uSide;
	
	// First figure out if someone already has this side for 
	// autohiding
	hwndAutoHide = (HWND) SHAppBarMessage(ABM_GETAUTOHIDEBAR, &abd);
	if (hwndAutoHide != NULL)
	{
		DebugMsg(TEXT("ERROR: Another appbar is already hiding ")
				 TEXT("on this edge.  Cannot set to autohide.\r\n"));
		return (FALSE);
	}

	// We can autohide on this edge.  Set the autohide style.
	abd.lParam = TRUE;			

	fSuccess = (BOOL) SHAppBarMessage(ABM_SETAUTOHIDEBAR, &abd);
	if (!fSuccess)
	{
		DebugMsg(TEXT("ERROR: Error trying to set autohidebar.\r\n"));
		ErrorHandler();
        return (FALSE);
	}
	else
	{
		// Since we're allowed to autohide, we need to adjust our screen 
		// rectangle to the autohidden position.  This will allow the system
		// to resize the desktop.
		pOpt->fAutoHide = TRUE;
		g_cxWidth = pOpt->cxWidth;
		g_cyHeight = pOpt->cyHeight;

		rc = g_rcAppBar;
		switch (pOpt->uSide)
		{
			case ABE_TOP:
				rc.bottom = rc.top + 2; 
				break;
			case ABE_BOTTOM:
				rc.top = rc.bottom - 2;
				break;
			case ABE_LEFT:
				rc.right = rc.left + 2;
				break;
			case ABE_RIGHT:
				rc.left = rc.right - 2;
				break;
		}

		AppBar_QuerySetPos(pOpt->uSide, &rc, &abd, TRUE);
	}

	return (TRUE);
}
=cut
sub AutoHide{
	my $hwnd = shift;
	DebugMsg "AppBar_AutoHide($hwnd)\n";
	my $hwndAutoHide;
	my $abd = new Win32::API::Struct('APPBARDATA');
	#POPTIONS pOpt = GetAppbarData(hwnd);
	my $fSuccess;	
	my $rc = new Win32::API::Struct('RECT');

	$abd->{cbSize} = $abd->sizeof();
	$abd->{hWnd} = $hwnd;
	$abd->{uEdge} = $Options{$hwnd}{-Side};

	#// First figure out if someone already has this side for 
	#// autohiding
	$hwndAutoHide = SHAppBarMessage(ABM_GETAUTOHIDEBAR, $abd);
	if ($hwndAutoHide != 0)
	{
		DebugMsg("ERROR: Another appbar is already hiding ",
				 "on this edge.  Cannot set to autohide.\r\n");
		return 1;
	}

	#// We can autohide on this edge.  Set the autohide style.
	$abd->{lParam} = 1;			

	$fSuccess = SHAppBarMessage(ABM_SETAUTOHIDEBAR, $abd);
	if (!$fSuccess)
	{
		DebugMsg "ERROR: Error trying to set autohidebar.\r\n";
		return 1;
	}else{
		#// Since we're allowed to autohide, we need to adjust our screen 
		#// rectangle to the autohidden position.  This will allow the system
		#// to resize the desktop.
		$Options{$hwnd}{-AutoHide} = 1;
		$Options{$hwnd}{g_cxWidth} = $Options{$hwnd}{-cxWidth};
		$Options{$hwnd}{g_cyHeight} = $Options{$hwnd}{-cyHeight};

		$rc = $Options{$hwnd}{Rect};
		
		if( $Options{$hwnd}{-Side} == ABE_TOP){	$rc->{bottom} = $rc->{top} + 2; }
		if( $Options{$hwnd}{-Side} == ABE_BOTTOM){$rc->{top} = $$rc->{bottom} - 2; }
		if( $Options{$hwnd}{-Side} == ABE_LEFT){$rc->{right} = $rc->{left} + 2;}
		if( $Options{$hwnd}{-Side} == ABE_RIGHT){$rc->{left} = $rc->{right} - 2; }

		QuerySetPos($Options{$hwnd}{-Side}, $rc, $abd, 1);
	}

	return 1;
}
=head
BOOL AppBar_NoAutoHide(HWND hwnd)
{
	HWND hwndAutoHide;
	APPBARDATA abd;
	POPTIONS pOpt = GetAppbarData(hwnd);
	BOOL fSuccess;	

	abd.cbSize = sizeof(APPBARDATA);
	abd.hWnd = hwnd;
	abd.uEdge = pOpt->uSide;
	
	// First let's check to see if we're the appbar attached to the
	// side of the screen
	abd.uEdge = pOpt->uSide;
	hwndAutoHide = (HWND) SHAppBarMessage(ABM_GETAUTOHIDEBAR, &abd);
	if (hwndAutoHide != hwnd)
	{
		DebugMsg(TEXT("ERROR: We're not hidden currently\r\n"));
		return (FALSE);
	}

	// We can autohide or stop autohide on this edge.  Set the autohide style.
	abd.lParam = FALSE;			

	fSuccess = (BOOL) SHAppBarMessage(ABM_SETAUTOHIDEBAR, &abd);
	if (!fSuccess)
	{
		DebugMsg(TEXT("ERROR: Error trying to set autohidebar.\r\n"));
		ErrorHandler();
        return (FALSE);
	}
	else
	{
		// Need to change the appbar to get the screen desktop space
		// back.  Also need to reattach the appbar to that edge of the
		// screen.
    	pOpt->fAutoHide = FALSE;		
    	
		pOpt->cxWidth = g_cxWidth;
		pOpt->cyHeight = g_cyHeight;

        AppBar_SetSide(hwnd, pOpt->uSide);	 
	}

	return (TRUE);
}
=cut
sub NoAutoHide{
	my $hwnd = shift;
	DebugMsg "AppBar_NoAutoHide($hwnd)\n";
	my $hwndAutoHide;
	my $abd = new Win32::API::Struct('APPBARDATA');
	#POPTIONS pOpt = GetAppbarData(hwnd);
	my $fSuccess;	

	$abd->{cbSize} = $abd->sizeof();
	$abd->{hWnd} = $hwnd;
	$abd->{uEdge} = $Options{$hwnd}{-Side};
	
	#// First let's check to see if we're the appbar attached to the
	#// side of the screen
	$abd->{uEdge} = $Options{$hwnd}{-Side};
	$hwndAutoHide = SHAppBarMessage(ABM_GETAUTOHIDEBAR, $abd);
	if ($hwndAutoHide != $hwnd)
	{
		DebugMsg "ERROR: We're not hidden currently\r\n";
		return 1;
	}

	#// We can autohide or stop autohide on this edge.  Set the autohide style.
	$abd->{lParam} = 0;			

	$fSuccess =  SHAppBarMessage(ABM_SETAUTOHIDEBAR, $abd);
	if (!$fSuccess)
	{
		DebugMsg "ERROR: Error trying to set autohidebar.\r\n";
        return 1;
	}
	else
	{
		#// Need to change the appbar to get the screen desktop space
		#// back.  Also need to reattach the appbar to that edge of the
		#// screen.
    	$Options{$hwnd}{-AutoHide} = 0;		
    	
		$Options{$hwnd}{-cxWidth} = $Options{$hwnd}{g_cxWidth};
		$Options{$hwnd}{-cyHeight} = $Options{$hwnd}{g_cyHeight};

        SetSide($hwnd, $Options{$hwnd}{-Side});	 
	}

	return 1;
}

#BOOL AppBar_SetSide(HWND hwnd, UINT uSide);

sub SetSide{ #(HWND hwnd, UINT uSide)
	my $hwnd = shift;
	my $uSide = shift;
	DebugMsg "AppBar_SetSide( $hwnd, $uSide )\n";
	my $abd = new Win32::API::Struct('APPBARDATA');
	my $rc = new Win32::API::Struct('RECT');
	my $fAutoHide = 0;

    #// Calculate the size of the screen so we can occupy the full width or
    #// height of the screen on the edge we request.
	$rc->{top} = 0;
	$rc->{left} = 0;
	$rc->{right} = Win32::GUI::GetSystemMetrics(SM_CXSCREEN);
	$rc->{bottom} = Win32::GUI::GetSystemMetrics(SM_CYSCREEN);

    #// Fill out the APPBARDATA struct with the basic information
	$abd->{cbSize} = $abd->sizeof();
	$abd->{hWnd} = $hwnd;

	#// If the appbar is autohidden, turn that off so we can move the bar
	if ($Options{$hwnd}{-AutoHide})
	{
		$fAutoHide = $Options{$hwnd}{-AutoHide};

		#// Turn off the redrawing of the desktop while we move things around.
		#// If you put any breakpoints in this area you will lock up the desktop
		#// Since turning off the desktop repaints turns it off for all the apps
		#// in the system
		Win32::GUI::SetRedraw(Win32::GUI::GetDesktopWindow(), 0);
  		SetAutoHide($hwnd, 0);
	}

    #// Adjust the rectangle to set our height or width depending on the
    #// side we want.
	if($uSide == ABE_TOP)   { $rc->{bottom} = $rc->{top}    + $Options{$hwnd}{-cyHeight}; }
	if($uSide == ABE_BOTTOM){ $rc->{top}    = $rc->{bottom} - $Options{$hwnd}{-cyHeight}; }
	if($uSide == ABE_LEFT)  { $rc->{right}  = $rc->{left}   + $Options{$hwnd}{-cxWidth};  }
	if($uSide == ABE_RIGHT) { $rc->{left}   = $rc->{right}  - $Options{$hwnd}{-cxWidth};  }

    #// Move the appbar to the new screen space.
	QuerySetPos($uSide, $rc, $abd, 1);
	
	#// If the appbar was hidden, rehide it now
	if ($fAutoHide)
	{
		SetAutoHide($hwnd, 1);

		Win32::GUI::SetRedraw(Win32::GUI::GetDesktopWindow(), 1);
		RedrawWindow(Win32::GUI::GetDesktopWindow(), undef, undef, 
					 RDW_INVALIDATE | RDW_UPDATENOW | RDW_ALLCHILDREN);			
	}

	return 1;
}

#void AppBar_SetAlwaysOnTop(HWND hwnd, BOOL fOnTop);


sub SetAlwaysOnTop{ #(HWND hwnd, BOOL fOnTop)
	my $hwnd = shift;
	my $fOnTop = shift;
	DebugMsg("AppBar_SetAlwaysOnTop ($hwnd,$fOnTop)\n");
	#// Update the window position to HWND_TOPMOST if we're to be always
	#// on top, or HWND_NOTOPMOST if we're not.
	SetWindowPos($hwnd, ($fOnTop) ? HWND_TOPMOST : HWND_NOTOPMOST,
	             0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);

	#// Store the setting in the appbar OPTIONS struct.
	$Options{$hwnd}{-AutoHide} = $fOnTop;
}

#void AppBar_Hide(HWND hwnd);

sub Hide{
	my $hwnd = shift;
	my $rc = new Win32::API::Struct('APPBARDATA');
	DebugMsg("AppBar_Hide ($hwnd)\n");
	#// Don't want to hide if AutoHide not set
	if (!$Options{$hwnd}{-AutoHide}){
		return;
	}

	#// Calculate a hidden rectangle to use
	$rc = $Options{$hwnd}{Rect};
	if ($Options{$hwnd}{'-Side'} == ABE_TOP)   { $rc->{bottom} = $rc->{top}    + 2; }
	if ($Options{$hwnd}{'-Side'} == ABE_BOTTOM){ $rc->{top}    = $rc->{bottom} - 2; }
	if ($Options{$hwnd}{'-Side'} == ABE_LEFT)  { $rc->{right}  = $rc->{left}   + 2; }
	if ($Options{$hwnd}{'-Side'} == ABE_RIGHT) { $rc->{left}   = $rc->{right}  - 2; }

	$Options{$hwnd}{Hiding} = 1;	
	SlideWindow($hwnd, $rc);
}

#void AppBar_UnHide(HWND hwnd);

sub UnHide{ #(HWND hwnd)
	my $hwnd = shift;
	DebugMsg("AppBar_UnHide ($hwnd)\n");
	SlideWindow($hwnd, $Options{$hwnd}{Rect});
	$Options{$hwnd}{Hiding} = 0;

	SetAutoHideTimer($hwnd);
}

#void AppBar_SetAutoHideTimer(HWND hwnd);

sub SetAutoHideTimer{ #(HWND hwnd)
	my $hwnd = shift;
	DebugMsg("AppBar_SetAutoHideTimer ($hwnd)\n");
	if ($Options{$hwnd}{-AutoHide}){
		#SetTimer($hwnd, IDT_AUTOHIDE, 500, NULL);
		# This creates a timer. mimic via win32-gui
		Win32::GUI::Window::AddTimer( $hwnd, 'appBarHide'.$hwnd, 50, -onTimer => \&HideTimer());
	}
}

sub HideTimer{
	my ($object, $wParam, $lParam, ) = @_;
	my $hwnd = $object->{-parent};
	DebugMsg( "HideTimer called\n");
	#// Kill the timer, we only need it to fire once.
	#KillTimer(hwnd, id);
	# This kills a timer. mimic via win32-gui
	$object->Kill();
	my $rc = new Win32::API::Struct('RECT');
	($rc->{left}, $rc->{top}, $rc->{right}, $rc->{bottom} ) = Win32::GUI::GetWindowRect($hwnd);
	if (($Options{$hwnd}{-AutoHide}) && ($Options{$hwnd}{Hiding})){
		#// Check to see if the cursor is still in the appbar.  If so,
		#// the unhide the window.
		my $x;
		my $y;
		($x, $y) = Win32::GUI::GetCursorPos();
		if( PtInRect($rc, $x, $y) ){
			UnHide($hwnd);
		}
	}
}

#void AppBar_SetAutoUnhideTimer(HWND hwnd);

sub SetAutoUnhideTimer{ #(HWND hwnd)
	my $hwnd = shift;
	DebugMsg("AppBar_SetAutoUnHide ($hwnd)\n");
	if ($Options{$hwnd}{-AutoHide} && $Options{$hwnd}{Hiding}){
		#SetTimer(hwnd, IDT_AUTOUNHIDE, 50, NULL);
		# This creates a timer, mimic in win32-gui
		Win32::GUI::Window::AddTimer( $hwnd, 'autoUnHide'.$hwnd, 50, -onTimer => \&UnHideTimer());
	}
}

sub UnHideTimer{
	my ($object, $wParam, $lParam) = @_;
	my $hwnd = $object->{-parent};
	my $hwndActive;
	DebugMsg( "UnHideTimer called\n");
	if ($Options{$hwnd}{-AutoHide} && !$Options{$hwnd}{Hiding}){
		#// Get the mouse position, the window position, and active 
		#// window
		my $x;
		my $y;
		($x, $y) = Win32::GUI::GetCursorPos();
		my $rc = new Win32::API::Struct('RECT');
		($rc->{left}, $rc->{top}, $rc->{right}, $rc->{bottom} ) = Win32::GUI::GetWindowRect($hwnd);
		$hwndActive = Win32::GUI::GetForegroundWindow();

		#// If the mouse is outside of our window, or we are not active,
		#// or at least one window is active, or we are not the parent
		#// of an active window, the hide the appbar window.
		if ((!PtInRect($rc, $x, $y)) && ($hwndActive != $hwnd) && 
			($hwndActive != undef) && (Win32::GUI::GetWindow($hwndActive,GW_OWNER) != $hwnd)){
			$object->Kill();
			Hide($hwnd);
		}
	}
}

#void AppBar_Callback(HWND, UINT, WPARAM, LPARAM);

sub Callback{
	my ($hwnd, $wParam, $lParam, $type, $msgcode) = @_;
    DebugMsg "AppBar Callback handler called!\n";
	DebugMsg "$hwnd, $wParam, $lParam, $type, $msgcode\n";
	$hwnd = $hwnd->{-handle};
	DebugMsg "$hwnd\n";
	if( $DEBUG >= 2){
		use Data::Dump;
		DebugMsg "AppBar_Callback : ",Data::Dump::dump($Options{$hwnd}),"\n";
	}
	my $abd = new Win32::API::Struct("APPBARDATA");
	#static HWND hwndZOrder = NULL;
	#POPTIONS pOpt = GetAppbarData(hwnd);
	    
	$abd->{cbSize} = $abd->sizeof();
    $abd->{hWnd} = $hwnd;
	

        #// Notifies the appbar that the taskbar's autohide or always-on-top 
        #// state has changed.  The appbar can use this to conform to the settings
        #// of the system taskbar.
	if($wParam == ABN_STATECHANGE) {
		DebugMsg("AppBarCallback: ABN_STATECHANGE\r\n");
	}

        #// Notifies the appbar when a full screen application is opening or 
        #// closing.  When a full screen app is opening, the appbar must drop
        #// to the bottom of the Z-Order.  When the app is closing, we should 
        #// restore our Z-order position.
	if($wParam == ABN_FULLSCREENAPP){
		DebugMsg("AppBarCallback: ABN_FULLSCREENAPP ($lParam)\r\n");
		if ($lParam){
			#// A full screen app is opening.  Move us to the bottom of the 
			#// Z-Order.  

			#// First get the window that we're underneath so we can correctly
			#// restore our position
			$Options{$hwnd}{zOrder} = GetWindow($hwnd, GW_HWNDPREV);
			DebugMsg $Options{$hwnd}{zOrder},"\n";
			#// Now move ourselves to the bottom of the Z-Order
			SetWindowPos($hwnd, HWND_BOTTOM, 0, 0, 0, 0, 
						 SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);            
		}else{
			DebugMsg "AppBar_Callback FULLSCREENAPP : $hwnd ",$Options{$hwnd}{-Top},',',$Options{$hwnd}{zOrder},"\n";
			#// The app is closing.  Restore the Z-order			   
			SetWindowPos($hwnd, $Options{$hwnd}{-Top} ? HWND_TOPMOST : $Options{$hwnd}{zOrder},
						 0, 0, 0, 0, 
						 SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);

			$Options{$hwnd}{zOrder} = 0;
		}
	}
        
        #// Notifies the appbar when an event has occured that may effect the 
        #// appbar's size and position.  These events include changes in the 
        #// taskbar's size, position, and visiblity as well as adding, removing,
        #// or resizing another appbar on the same side of the screen.
    if($wParam == ABN_POSCHANGED) {
		DebugMsg("AppBarCallback: ABN_POSCHANGED\r\n");
		#// Update our position in response to the system change
		PosChanged($abd);
	}
}

=head Needed Activity Triggers:
WindowActivate
WindowPosChanged
=cut
sub WindowActivate{
	my $hWnd = shift;
	my $abd = new Win32::API::Struct('APPBARDATA');
	$hWnd = $hWnd->{-handle};
	DebugMsg("AppBar_WindowActivate ($hWnd)\n");
	$abd->{hWnd} = $hWnd;
	$abd->{cbSize} = $abd->sizeof();
		
	SHAppBarMessage( ABM_ACTIVATE, $abd);
	1;
}

sub WindowPosChanged{
	my $hWnd = shift;
	$hWnd = $hWnd->{-handle};
	my $abd = new Win32::API::Struct('APPBARDATA');
	DebugMsg("AppBar_WindowPosChanged ($hWnd)\n");
	$abd->{hWnd} = $hWnd;
	$abd->{cbSize} = $abd->sizeof();
	DebugMsg("AppBar_WindowPosChanged ($hWnd) : Sending Message\n");
	SHAppBarMessage( ABN_POSCHANGED, $abd);
	DebugMsg("AppBar_WindowPosChanged ($hWnd) : Message Sent\n");
	1;
}

=head unused
sub GetAppBarData {
	my $hWnd = shift;
	
	return $Options{$hWnd};
}
=cut

sub PtInRect{
	my $rc = shift;
	my $x = shift;
	my $y = shift;
	DebugMsg("AppBar_PtInRect ()\n");
	if( $x >= $rc->{left} && $x <= $rc->{right} &&
		$y >= $rc->{top}  && $y <= $rc->{bottom} ){
		return 1;
	}
	
	return 0;
}


sub SlideWindow{ #(HWND hwnd, LPRECT prc)
	my $hwnd = shift;
	my $rcNew = shift;
	DebugMsg("AppBar_SlideWindow ($hwnd)\n");
	my $rcOld = new Win32::API::Struct('RECT');
	my $x;
	my $y;
	my $dx;
	my $dy;
	my $t;
	my $t0;
	my $dt;
	
	my $fShow;

	if ((g_dtSlideShow > 0) && (g_dtSlideHide > 0))	{
		#GetWindowRect(hwnd, &rcOld);
		($rcOld->{left}, $rcOld->{top}, 
		$rcOld->{right}, $rcOld->{bottom} ) = Win32::GUI::GetWindowRect($hwnd);

		$fShow = (($rcNew->{bottom} - $rcNew->{top}) > ($rcOld->{bottom} - $rcOld->{top})) ||
				 (($rcNew->{right} - $rcNew->{left}) > ($rcOld->{right} - $rcOld->{left}));

		$dx = ($rcNew->{right} - $rcOld->{right}) + ($rcNew->{left} - $rcOld->{left});
		$dy = ($rcNew->{bottom} - $rcOld->{bottom}) + ($rcNew->{top} - $rcOld->{top});

		if ($fShow){
			$rcOld = $rcNew;
			OffsetRect($rcOld, -1*($dx), -1*($dy));
			SetWindowPos($hwnd, undef, $rcOld->{left}, $rcOld->{top},
					$rcOld->{right} - $rcOld->{left}, $rcOld->{bottom} - $rcOld->{top},
					SWP_NOZORDER | SWP_NOACTIVATE | SWP_DRAWFRAME);

			$dt = g_dtSlideShow;
		}else{
			$dt = g_dtSlideHide;
		}

		#hThreadMe = GetCurrentThread();
		#priority = GetThreadPriority(hThreadMe);
		#SetThreadPriority(hThreadMe, THREAD_PRIORITY_HIGHEST);

		$t0 = GetTickCount();
		$t = $t0;
		while (($t) < $t0 + $dt){
			$x = $rcOld->{left} + $dx * ($t - $t0) / $dt;
			$y = $rcOld->{top} + $dy * ($t - $t0) / $dt;

			SetWindowPos($hwnd, NULL, $x, $y, 0, 0,
						 SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);
			if ($fShow){
				Win32::GUI::Update($hwnd);
			}else{
				Win32::GUI::Update(Win32::GUI::GetDesktopWindow());
			}
			$t = GetTickCount();
		}

		#SetThreadPriority(hThreadMe, priority);
	}

	SetWindowPos($hwnd, undef, $rcNew->{left}, $rcNew->{top},
				 $rcNew->{right} - $rcNew->{left}, $rcNew->{bottom} - $rcNew->{top},
				 SWP_NOZORDER | SWP_NOACTIVATE | SWP_DRAWFRAME);

}

#====
#DUH.
return 1;

