{
	my $is_msvc = grep { $c{cc} eq $_ } ( qw(cl cl.exe) );
	my $is_mingw = grep { $c{cc} eq $_ } ( qw(gcc gcc.exe) );

	$c{rm_f} = '$(PERL) -MExtUtils::Command -e rm_f';

	if( $is_msvc ) {
		$c{o} = '.obj';
		$c{ld_out} = '-Fo';
		$c{cc_debug} = '-Zi';
		$c{ld_debug} = '-debug';
		$c{platform} = 'win32';
		$c{cp} = 'copy';
		$c{slash} = '\\';
	}
	elsif( $is_mingw ) {
		$c{ld} = 'gcc';
		# if your perl is ActivePerl, then libs are .lib files,
		# not necessary, and gcc does not like them
		$c{libs} = ' ' if $c{libs} =~ m/\.lib\s/i;
	}
}

require "platforms/dynload/dlopen.config";
require "platforms/env/win32.config";
require "platforms/sleep/win32.config";
require "platforms/time/time.config";
require "platforms/time/SystemTime.config";
