#!perl -w

=pod

=head1 NAME

tools/docs/opslist.pl - generate operator class list pod

=head1 SYNOPSIS

    % perl tools/docs/opslist.pl

=head1 DESCRIPTION

this script will generate a pod document (docs/ops/opslist.pod) listing parrot operators, organized alphabetically, by operator class

=cut

use strict;

use FindBin qw($Bin);
use File::Spec::Functions qw(catfile catdir);
use File::Find qw(find);
use File::Basename qw(fileparse);


my $parrotroot= catdir($Bin, qw/.. ../);
my $opsext= qr/\.ops$/;
my $podfile = catfile($parrotroot, qw/docs ops opslist.pod/);
my $op_pat= qr/(?x) \s* inline? \s+ op \s+ (\S+) \s* \( /;

my( @opsfiles, %ops );

## find all ops files
find 
	sub{ 
		push @opsfiles => $File::Find::name 
			if -f $_ and m/$opsext/;
	} 
	=> catdir($parrotroot, qw/ops/);


for my $opsfile ( @opsfiles )
{
	## read opsfile to array
	my @data= sub{ local *ARGV; @ARGV= @_; <> }->( $opsfile );
	for( @data )
	{
		## create hash of ops in hash of classes
		##   if the line matches the operator definition pattern
		++${ $ops{fileparse($opsfile, $opsext)} }{ $1 }
			if m/$op_pat/;
	}
}

open( POD, '>', $podfile )
	or die qq{Can't open $podfile for writing: $!};

print POD <<HEAD;

=pod 

=head1 OPERATOR CLASS LIST

=over 8

HEAD

for my $class ( sort keys %ops )
{
	print POD "=item B<$class>\n\n";
	print POD join ', ' => sort keys %{$ops{$class}};
	print POD "\n\n";
}

print POD <<TAIL;
=back

=cut
TAIL

close POD;
