#!/usr/bin/perl

use strict;
use lib qw(../../../lib .);
use Test::More tests => 25;
use run_tcl;

my($tcl,$expected);

$tcl = <<'EOTCL';
 puts -nonewline [string first a abcdef]
EOTCL
$expected = "0";
is(output($tcl),$expected,"first, initial");

$tcl = <<'EOTCL';
 puts -nonewline [string first a federal]
EOTCL
$expected = "5";
is(output($tcl),$expected,"first, middle");

$tcl = <<'EOTCL';
 puts -nonewline [string first c green ]
EOTCL
$expected = "-1";
is(output($tcl),$expected,"first, failure");

$tcl = <<'EOTCL';
 puts -nonewline [string first c green 0]
EOTCL
$expected = "-1";
is(output($tcl),$expected,"first, index, failure");

$tcl = <<'EOTCL';
 puts -nonewline [string first c abcd end-3]
EOTCL
$expected = "2";
is(output($tcl),$expected,"first, index, end");

$tcl = <<'EOTCL';
 puts -nonewline [string first c abcd 20]
EOTCL
$expected = "-1";
is(output($tcl),$expected,"first, index, overshot");

$tcl = <<'EOTCL';
 puts -nonewline [string first c abcd 1]
EOTCL
$expected = "2";
is(output($tcl),$expected,"first, index");

$tcl = <<'EOTCL';
 puts -nonewline [string first c abcd joe]
EOTCL
$expected = "bad index \"joe\": must be integer or end?-integer?";
is(output($tcl),$expected,"first, index, invalid index");

$tcl = <<'EOTCL';
 puts -nonewline [string first]
EOTCL
$expected = "wrong # args: should be \"string first subString string ?startIndex?\"";
is(output($tcl),$expected,"first, too few args");

$tcl = <<'EOTCL';
 puts -nonewline [string first a b c d]
EOTCL
$expected = "wrong # args: should be \"string first subString string ?startIndex?\"";
is(output($tcl),$expected,"first, too many args");

$tcl = <<'EOTCL';
 puts -nonewline [string index a b c]
EOTCL
$expected = "wrong # args: should be \"string index string charIndex\"";
is(output($tcl),$expected,"index, too many args");

$tcl = <<'EOTCL';
 puts -nonewline [string index]
EOTCL
$expected = "wrong # args: should be \"string index string charIndex\"";
is(output($tcl),$expected,"index, too few args");

$tcl = <<'EOTCL';
 puts -nonewline [string index abcde 0]
EOTCL
$expected = "a";
is(output($tcl),$expected,"index, initial");

$tcl = <<'EOTCL';
 puts -nonewline [string index abcde end]
EOTCL
$expected = "e";
is(output($tcl),$expected,"index, end");

$tcl = <<'EOTCL';
 puts -nonewline [string index abcde 10]
EOTCL
$expected = "";
is(output($tcl),$expected,"index, too far");

TODO: {
local $TODO = "don't handle negative indices yet.";
$tcl = <<'EOTCL';
 puts -nonewline [string index abcde -1]
EOTCL
$expected = "";
is(output($tcl),$expected,"index, too near?");
}

$tcl = <<'EOTCL';
 puts -nonewline [string length a b]
EOTCL
$expected = "wrong # args: should be \"string length string\"";
is(output($tcl),$expected,"length, too many args");

$tcl = <<'EOTCL';
 puts -nonewline [string length]
EOTCL
$expected = "wrong # args: should be \"string length string\"";
is(output($tcl),$expected,"length, too few args");

$tcl = <<'EOTCL';
 puts -nonewline [string length 10]
EOTCL
$expected = "2";
is(output($tcl),$expected,"length, simple");

$tcl = <<'EOTCL';
 puts -nonewline [string length ""]
EOTCL
$expected = "0";
is(output($tcl),$expected,"length, simple");

$tcl = <<'EOTCL';
 puts -nonewline [string range a b]
EOTCL
$expected = "wrong # args: should be \"string range string first last\"";
is(output($tcl),$expected,"range, too many args");

$tcl = <<'EOTCL';
 puts -nonewline [string range a b c d]
EOTCL
$expected = "wrong # args: should be \"string range string first last\"";
is(output($tcl),$expected,"range, too few args");

$tcl = <<'EOTCL';
 puts -nonewline [string range abcde 0 end]
EOTCL
$expected = "abcde";
is(output($tcl),$expected,"range, total");

$tcl = <<'EOTCL';
 puts -nonewline [string range abcde 1 end-1]
EOTCL
$expected = "bcd";
is(output($tcl),$expected,"range, partial");

$tcl = <<'EOTCL';
 puts -nonewline [string range abcde end-20 20]
EOTCL
$expected = "abcde";
is(output($tcl),$expected,"range, overextended");
