#!/bin/bash

set -e
SD="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

# commit 1 -- Make SGML compatible with XML
###############################################################################
cat $SD/docbook-sgml-xml.dcl postgres.sgml > postgres.sgmltmp && mv postgres.sgmltmp postgres.sgml
for file_sgml in *.sgml ref/*.sgml; do
#    grep -q ' < ' $file_sgml && perl -p -i -e 's/ < / &lt; /g' $file_sgml
    perl -i $SD/sgml2xml.pl $file_sgml

    # convert id's to lower case # Adjusting to SQL-CREATETABLE-storage-parameters is error-prone approach
    perl -0777 -p -i -e 's/(<(refentry|refsect1|refsect2|refsect3|varlistentry|title|chapter|sect2|biblioentry)\s+id=")([\w-]+)(")/$1\L$3$4/gm' $file_sgml
    perl -0777 -p -i -e 's/(<(xref|link)\s+linkend=")([\w-]+)(")/$1\L$3$4/gm' $file_sgml
    perl -0777 -p -i -e 's/(<(xref|link)[^>]*?endterm=")([\w-]+)(")/$1\L$3$4/gm' $file_sgml
    perl -0777 -p -i -e 's/(<(indexterm)\s+zone=")([\w-]+)(")/$1\L$3$4/gm' $file_sgml

    # Remove \n before </optional> up as it becomes significant inside <pre> (see plpgsql / plpgsql-control-structures.html / ELSIF ... </optional>)
    perl -0777 -p -i -e 's/\n(<\/(optional)>)/$1/gm' $file_sgml
done
###############################################################################
