#!/bin/bash

set -e
SD="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

# commit 2
###############################################################################
if [ X"$(basename `pwd`)" == X'sgml' ]; then
    cd ..
    mv sgml xml
    cd xml
fi

[ -f version.sgml ] && mv version.sgml version.ent
for f in *.sgml; do mv $f `basename $f .sgml`.xml; done
for f in ref/*.sgml; do mv $f ref/`basename $f .sgml`.xml; done

# Update comments in xml's
for file_xml in *.xml ref/*.xml; do
    perl -0777 -p -i -e 's/(<!--\s+doc\/src)\/sgml(.*?)\.sgml\b/$1\/xml$2.xml/gm' $file_xml
    perl -p -i -e 's/(<!-- See header comment in release).sgml\b/$1.xml/g' $file_xml
    perl -p -i -e 's/(<!-- See also the entry for this in [a-z-_]+).sgml\b/$1.xml/g' $file_xml
done

# Update comments in other files
for file in README.links mk_feature_tables.pl; do
    perl -0777 -p -i -e 's/(<!--\s+doc\/src)\/sgml\//$1\/xml\//gm' $file
done

perl -p -i -e 's/(list of usable )sgml( source files in this directory)/$1xml$2/g' ref/allfiles.xml

for file_list in filelist.xml ref/allfiles.xml; do
    perl -p -i -e 's/\.sgml/.xml/g' $file_list
done

# Replace SGML header with xml PI
perl -0777 -p -i -e 's/<!SGML(.*?)\n>/<?xml version="1.0" encoding="utf-8"?>/sg' postgres.xml
# Replace DOCTYPE
perl -p -i -e 's#<!DOCTYPE book PUBLIC "-//OASIS//DTD DocBook V4.2//EN"#<!DOCTYPE book PUBLIC "-//OASIS//DTD DocBook XML V4.2//EN" "http://www.oasis-open.org/docbook/xml/4.2/docbookx.dtd"#sg' postgres.xml
# Add W3C entities
perl -p -i -e 's#(%filelist;)#$1\n<!ENTITY % isoent SYSTEM "http://www.w3.org/2003/entities/2007/isopub.ent"> %isoent;\n<!ENTITY % xhtml1-lat1 SYSTEM "http://www.w3.org/2003/entities/2007/xhtml1-lat1.ent"> %xhtml1-lat1;\n<!ENTITY % isolat2 SYSTEM "http://www.w3.org/2003/entities/2007/isolat2.ent"> %isolat2;\n<!ENTITY % isogrk3 SYSTEM "http://www.w3.org/2003/entities/2007/isogrk3.ent"> %isogrk3;#sg' postgres.xml

# Replace references
perl -p -i -e 's/(version).sgml/$1.ent/g' postgres.xml
perl -p -i -e 's/(version|filelist|reference).sgml/$1.xml/g' postgres.xml

# Change bookindex includes # TODO
# perl -p -i -e 's#<!\[%include-index;\[&bookindex;\]\]>#&bookindex;#g' postgres.xml
perl -p -i -e 's#<!\[%include-index;\[&bookindex;\]\]>#<!-- part id="bookindex-part" condition="include-index">&bookindex;</part -->#g' postgres.xml
perl -p -i -e 's#<!\[%include-xslt-index;\[<index id="bookindex"></index>\]\]>#<index id="bookindex"></index>#g' postgres.xml

cp $SD/patches/xml/Makefile ./
cp $SD/patches/xml/stylesheet-single.xsl ./
cp $SD/patches/xml/profile-onechunk.xsl ./
cp $SD/patches/xml/stylesheet-epub.xsl ./
cp $SD/patches/xml/stylesheet-speedup-epub.xsl ./
cp $SD/patches/xml/pg-customize-fo.xsl ./
cp $SD/patches/xml/standalone-install.xml ./
cp $SD/patches/xml/profiling.xsl ./ # TODO:remove
cp $SD/patches/xml/installation-single.xsl ./

perl -p -i -e 's#/postgres\.xml##g' ./.gitignore
perl -p -i -e 's#GENERATED_SGML$#GENERATED_XML#g' ./.gitignore
perl -p -i -e 's#version\.sgml$#version.ent#g' ./.gitignore
perl -p -i -e 's#\.sgml$#.xml#g' ./.gitignore

(
cd ../../../
for p in $@; do
    patch -p1 --no-backup-if-mismatch -i $p
done
)
###############################################################################
