<?xml version='1.0'?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY % version SYSTEM "version.ent">
%version;
]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<xsl:output
    doctype-public="-//OASIS//DTD DocBook XML V4.2//EN"
    doctype-system="http://www.oasis-open.org/docbook/xml/4.2/docbookx.dtd"/>

<xsl:template match="@*|node()">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()" />
  </xsl:copy>
</xsl:template>

<xsl:template match="/">

<article id="installation">
 <title><productname>PostgreSQL</productname> Installation from Source Code</title>

 <para>
  This document describes the installation of
  <productname>PostgreSQL</productname> using this source code distribution.
 </para>

 <xsl:apply-templates select="//*[@id='install-short']"/>
 <xsl:apply-templates select="//*[@id='install-requirements']"/>
 <xsl:apply-templates select="//*[@id='install-procedure']"/>
 <xsl:apply-templates select="//*[@id='install-post']"/>

 <sect1 id="install-getting-started">
  <title>Getting Started</title>

  <para>
   The following is a quick summary of how to get <productname>PostgreSQL</productname> up and
   running once installed. The main documentation contains more information.
  </para>

  <procedure>
   <step>
    <para>
     Create a user account for the <productname>PostgreSQL</productname>
     server. This is the user the server will run as. For production
     use you should create a separate, unprivileged account
     (<quote>postgres</quote> is commonly used). If you do not have root
     access or just want to play around, your own user account is
     enough, but running the server as root is a security risk and
     will not work.
<screen><userinput>adduser postgres</userinput></screen>
    </para>
   </step>

   <step>
    <para>
     Create a database installation with the <command>initdb</command>
     command. To run <command>initdb</command> you must be logged in to your
     <productname>PostgreSQL</productname> server account. It will not work as
     root.
<screen>root# <userinput>mkdir /usr/local/pgsql/data</userinput>
root# <userinput>chown postgres /usr/local/pgsql/data</userinput>
root# <userinput>su - postgres</userinput>
postgres$ <userinput>/usr/local/pgsql/bin/initdb -D /usr/local/pgsql/data</userinput></screen>
    </para>

    <para>
     The <option>-D</option> option specifies the location where the data
     will be stored. You can use any path you want, it does not have
     to be under the installation directory. Just make sure that the
     server account can write to the directory (or create it, if it
     doesn't already exist) before starting <command>initdb</command>, as
     illustrated here.
    </para>
   </step>

   <step>
    <para>
     At this point, if you did not use the <command>initdb</command> <literal>-A</literal>
     option, you might want to modify <filename>pg_hba.conf</filename> to control
     local access to the server before you start it.  The default is to
     trust all local users.
    </para>
   </step>

   <step>
    <para>
     The previous <command>initdb</command> step should have told you how to
     start up the database server. Do so now. The command should look
     something like:
<programlisting>/usr/local/pgsql/bin/postgres -D /usr/local/pgsql/data</programlisting>
     This will start the server in the foreground. To put the server
     in the background use something like:
<programlisting>nohup /usr/local/pgsql/bin/postgres -D /usr/local/pgsql/data \
    &lt;/dev/null &gt;&gt;server.log 2&gt;&amp;1 &lt;/dev/null &amp;</programlisting>
    </para>

    <para>
     To stop a server running in the background you can type:
<programlisting>kill `cat /usr/local/pgsql/data/postmaster.pid`</programlisting>
    </para>
   </step>

   <step>
    <para>
     Create a database:
<screen><userinput>createdb testdb</userinput></screen>
     Then enter:
<screen><userinput>psql testdb</userinput></screen>
     to connect to that database. At the prompt you can enter SQL
     commands and start experimenting.
    </para>
   </step>
  </procedure>
 </sect1>

 <sect1 id="install-whatnow">
  <title>What Now?</title>

  <para>
   <itemizedlist>
    <listitem>
     <para>
      The <productname>PostgreSQL</productname> distribution contains a
      comprehensive documentation set, which you should read sometime.
      After installation, the documentation can be accessed by
      pointing your browser to
      <filename>/usr/local/pgsql/doc/html/index.html</filename>, unless you
      changed the installation directories.
     </para>

     <para>
      The first few chapters of the main documentation are the Tutorial,
      which should be your first reading if you are completely new to
      <acronym>SQL</acronym> databases.  If you are familiar with database
      concepts then you want to proceed with part on server
      administration, which contains information about how to set up
      the database server, database users, and authentication.
     </para>
    </listitem>

    <listitem>
     <para>
      Usually, you will want to modify your computer so that it will
      automatically start the database server whenever it boots. Some
      suggestions for this are in the documentation.
     </para>
    </listitem>

    <listitem>
     <para>
      Run the regression tests against the installed server (using
      <command>make installcheck</command>). If you didn't run the
      tests before installation, you should definitely do it now. This
      is also explained in the documentation.
     </para>
    </listitem>

    <listitem>
     <para>
      By default, <productname>PostgreSQL</productname> is configured to run on
      minimal hardware.  This allows it to start up with almost any
      hardware configuration. The default configuration is, however,
      not designed for optimum performance. To achieve optimum
      performance, several server parameters must be adjusted, the two
      most common being <varname>shared_buffers</varname> and
      <varname>work_mem</varname>.
      Other parameters mentioned in the documentation also affect
      performance.
     </para>
    </listitem>
   </itemizedlist>
  </para>
 </sect1>

 <xsl:apply-templates select="//*[@id='supported-platforms']"/>
 <xsl:apply-templates select="//*[@id='installation-platform-notes']"/>

</article>
</xsl:template>

<xsl:template match="*[@xreflabel]">
  <xsl:value-of select="@xreflabel" />
</xsl:template>

</xsl:stylesheet>
