#!/bin/bash

set -e
HM=`pwd`
SD="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
CD=postgresql.chk
TD=/tmp/postgresql.chk

# Internal functions
###############################################################################
compareXhtml() {
    # Compare texts as html's differ in id's and not significant white-space characters
    # Convert html to text in the same directory for inner links to be the same
    [ -d $TD/xhtml ] && rm -rf $TD/xhtml
    cp -R $1 $TD/xhtml
    rm -rf $1-text; mkdir $1-text
    for f in $TD/xhtml/*.html; do fn=`basename $f`; lynx $f --dump >$1-text/$fn; done
    # remove random generated id
    for f in $1-text/*.html; do perl -p -i -e 's/(\.html#(ftn\.|ientry-)?id)[a-z][0-9]+/$1/g' $f; done

    rm -rf $TD/xhtml
    cp -R $2 $TD/xhtml
    mkdir $2-text
    for f in $TD/xhtml/*.html; do fn=`basename $f`; lynx $f --dump >$2-text/$fn; done
    # remove random generated id
    for f in $2-text/*.html; do perl -p -i -e 's/(\.html#(ftn\.|ientry-)?id)[a-z][0-9]+/$1/g' $f; done

    # TODO: remove -B
    diff -u -b -B -r $1-text $2-text
}
###############################################################################
rm -rf $CD
rm -rf $TD
mkdir $TD
# this will create ./postgresql.chk/
# git clone git://git.postgresql.org/git/postgresql.git $CD
cp -R postgresql.git $CD
cd $CD
rm -rf *
git reset --hard HEAD
git checkout 684cf76b8~1
./configure --enable-nls --without-readline --without-zlib

cd doc/src/sgml

$SD/move2xml-commit0.sh
# Build docs
###############################################################################
export SP_ENCODING=XML
make clean
make html
cp -R html $TD/html-sgml0
rm -rf html html-stamp
###############################################################################

$SD/move2xml-commit1.sh

# Build docs and check for differences after commit 1
###############################################################################
make clean
make html
cp -R html $TD/html-sgml1
rm -rf html html-stamp

compareXhtml $TD/html-sgml0 $TD/html-sgml1
echo 'Step 1 passed.'

###############################################################################

rm -rf html html-stamp postgres.xml *.pdf

$SD/move2xml-commit2.sh $SD/patches/xml/*.patch

###############################################################################

# Make sure that docbook-xsl 1.79+ is used
# When building onechunk html use custom xsl (as docbook-xsl is not fixed yet,
#  see: https://sourceforge.net/p/docbook/bugs/1335/ and https://github.com/docbook/xslt10-stylesheets/issues/12)

# Build docs and check for differences with the state after commit 1
###############################################################################
make clean
time make html
cp -R html $TD/html-xml

# Compare html-sgml1 with html-xml
compareXhtml $TD/html-sgml1 $TD/html-xml
echo 'Step 2 passed.'
###############################################################################

echo 'OK'
