#include "postgres.h"
#include "funcapi.h"
#include "fmgr.h"
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <stdlib.h>


typedef struct tseries_mem {
  bytea *res;
  float *current;
  int    length;
  int    ffree;
} tseries_mem;

// sloupce ts1, ts2, ts3 se pouziji ve funkci time_series_unpack3

typedef struct fcetab_info {
  float *current;
  int    length;
  int    cols;
  int    row;
  char **values;
  int    ts1;
  int    ts2;
  int    ts3;
} fcetab_info;

#define DEFAULT_BLOCK 10000

int storefloat(struct tseries_mem *ts, float value)
{
  if (ts -> res == NULL) 
    {
      ts -> res = palloc(VARHDRSZ + sizeof(int) + sizeof(float)*DEFAULT_BLOCK);
      if (ts -> res == NULL) return 1;
      ts -> current = (float*)((int*)VARDATA(ts -> res) + 1);
      ts -> ffree = DEFAULT_BLOCK; ts -> length = 0;
    }
  if (ts -> ffree-- == 0)
    {
      int nsize = VARHDRSZ + sizeof(int) + 
	sizeof(float) * (ts -> length + DEFAULT_BLOCK);
      ts -> res = (bytea*) SPI_repalloc (ts -> res, nsize);
      if (ts -> res == NULL) return 1;
      ts -> ffree = DEFAULT_BLOCK - 1;
      ts -> current = (float*)(VARDATA (ts-> res) + sizeof(int) + sizeof(float)*ts -> length);
    }

  *ts -> current++ = value;
  ts -> length++;
  
  return 0;
}

int sgetc (char **src, int *length)
{
  if ((*length)-- > 0) return *(*src)++;
  else return EOF;
}

int gettok (char **src, int *length, float *rv)
{
  int  c; char buff[60];
  int i = 0; int hasdot = 0;

  while ((c = sgetc (src, length)) != EOF)
	  if (!isblank (c)) 
		  break;

  if (c == EOF)  return 0; 
  if (c == ',')  return 1; 
  if (c == '\n') return 2; 
  if (c == '+' || c == '-')
    {
      if (i == 60) return -1;
      buff [i++] = c; 
      if ((c = sgetc (src, length)) == EOF) return -1; 
    }
  if (!isdigit (c))return -1;
  if (i == 60)     return -1; 
  buff [i++] = (char) c;

  while ((c = sgetc (src, length))!= EOF)
    {
      if (c == '.')
        {
          if (hasdot)  return -1; 
	  if (i == 59) return -1;
          hasdot = 1; buff [i++] = (char)c; 
	  if ((c = sgetc (src, length)) == EOF) return -1; 
	  buff [i++] = (char)c; 
        }
      else if (!isdigit (c))
        {
          *(*src)--; (*length)++; break;
        }
      else
	{
	  if (i == 60) return -1;
	  buff [i++] = (char) c;
	}
    }
  if (i)
    {
      buff[i] = '\0'; 
      *rv = (float) atof (buff);
      return 3;     
    }
  else
    return 4; 
}

int readtseries(char *src, int length, struct tseries_mem *ts)
{
  int cols = 0; float rv;
  int retval, i; int nextrv = 3;


  ts -> res = NULL;

  while ((retval = gettok(&src, &length, &rv)) != 0)
    {
      if (retval == 2)      break;
      if (retval != nextrv) return -1;
      if (retval == 1)      nextrv = 3;
      else if (retval == 3)
	{
	  if (storefloat (ts, rv)) return -2;
	  cols++; nextrv = 1;
	}
    }

  *((int*)VARDATA(ts -> res)) = cols;
  VARATT_SIZEP (ts -> res) = VARHDRSZ +  sizeof (int);
  
  while (retval != 0) {
    for (i = 0; i < cols; i++) 
      {
	retval = gettok(&src, &length, &rv);
	if ((retval == 2 || retval == 0) && i == 0)
	  {
	    VARATT_SIZEP (ts -> res) = VARHDRSZ +  sizeof (int) + sizeof(float)* ts -> length;
	    return cols;
	  }

	if (retval != 3) return -1;
	if (storefloat (ts, rv)) return -2;

	retval = gettok(&src, &length, &rv);
	if (retval == 3) return -1;
      }
    if (retval == 1) return -1;
  }
 
  VARATT_SIZEP (ts -> res) = VARHDRSZ +  sizeof (int) + sizeof(float)* ts -> length;

  return cols;
}

PG_FUNCTION_INFO_V1 (time_series_pack);
PG_FUNCTION_INFO_V1 (time_series_unpack);
PG_FUNCTION_INFO_V1 (join_packed_time_series);
PG_FUNCTION_INFO_V1 (time_series_unpack3);

Datum join_packed_time_series (PG_FUNCTION_ARGS)
{
  bytea *src1, *src2, *result;

  src1 = PG_GETARG_BYTEA_P (0);
  src2 = PG_GETARG_BYTEA_P (1);

  float *data1 = (float*) VARDATA(src1);
  float *data2 = (float*) VARDATA(src2);

  if (*(int*)data1++ != *(int*)data2++)
    elog(ERROR, "sets od tseries are incompatible!");

  int nlen = VARSIZE(src1) + VARSIZE (src2) -2 * VARHDRSZ - 2 *sizeof (int);
  result = (bytea*) palloc (nlen + VARHDRSZ + 2 * sizeof (int));
  if (result == NULL) elog (ERROR, "Out of memory.");

  VARATT_SIZEP (result) = nlen + VARHDRSZ + 2 * sizeof (int);

  memcpy (VARDATA(result), VARDATA(src1), VARSIZE (src1) - VARHDRSZ);
  memcpy (VARDATA(result) + VARSIZE (src1) - VARHDRSZ, VARDATA(src2) + sizeof(int), 
	  VARSIZE (src2) - VARHDRSZ - sizeof(int));

  PG_RETURN_BYTEA_P (result);
}


Datum time_series_unpack (PG_FUNCTION_ARGS)
{
  FuncCallContext *funcctx;
  TupleDesc        tupdesc;
  TupleTableSlot  *slot;
  AttInMetadata   *attinmeta;
  fcetab_info     *fceinfo;

  if (SRF_IS_FIRSTCALL ())
    {
      MemoryContext oldcontext;
      funcctx = SRF_FIRSTCALL_INIT ();
      oldcontext = MemoryContextSwitchTo (funcctx -> multi_call_memory_ctx);

      tupdesc = RelationNameGetTupleDesc ("_time_series");
      slot = TupleDescGetSlot (tupdesc);
      funcctx -> slot = slot;

      attinmeta = TupleDescGetAttInMetadata (tupdesc);
      funcctx -> attinmeta = attinmeta;

      fceinfo = (fcetab_info*) palloc (sizeof (fcetab_info));

      bytea *ba = PG_GETARG_BYTEA_P (0);
      fceinfo -> length  = (VARSIZE(ba) - VARHDRSZ - sizeof(int)) / sizeof (float) ;
      fceinfo -> current = (float*)VARDATA(ba);
      fceinfo -> row     = 1;
      fceinfo -> cols    = *(int*)fceinfo -> current++;
      fceinfo -> length /= fceinfo -> cols;

      int col = PG_GETARG_INT32 (1) - 1;

      if (col < 0 || col >= fceinfo -> cols)
	elog(ERROR, "tseries index is out of value!");

      fceinfo -> values = (char **) palloc (2 * sizeof (char *));
      fceinfo -> values [0] = (char*) palloc (16 * sizeof (char));
      fceinfo -> values [1] = (char*) palloc (16 * sizeof (char));

      fceinfo -> current += col;
      funcctx -> user_fctx = (void*) fceinfo;
      
      MemoryContextSwitchTo (oldcontext);
    }

  funcctx = SRF_PERCALL_SETUP ();
  fceinfo = (fcetab_info*) funcctx -> user_fctx;

  if (fceinfo->length--)
    {
      Datum result; HeapTuple tuple;

      snprintf (fceinfo -> values [0], 16, "%d", ( fceinfo -> row++));
      snprintf (fceinfo -> values [1], 16, "%f", *fceinfo -> current);

      if (fceinfo -> length)
	fceinfo -> current += fceinfo -> cols; 
      
      tuple = BuildTupleFromCStrings (funcctx -> attinmeta, fceinfo -> values);
      result = TupleGetDatum (funcctx -> slot, tuple);

      SRF_RETURN_NEXT (funcctx, result);
    }
  else
    {
      SRF_RETURN_DONE (funcctx);
    }
}

Datum time_series_pack (PG_FUNCTION_ARGS)
{
  text *txt    = PG_GETARG_TEXT_P(0);
  char *src    = VARDATA(txt);
  long  length = VARSIZE(txt) - VARHDRSZ;

  struct tseries_mem *ts = palloc(sizeof(tseries_mem));
  if (ts == NULL) elog (ERROR, "Out of memory.");

  int cols = readtseries(src, length, ts);

  if (cols == -1) elog (ERROR, "Parse error.");
  if (cols == -2) elog (ERROR, "Out of memory.");

  PG_RETURN_BYTEA_P (ts -> res);
}

Datum time_series_unpack3 (PG_FUNCTION_ARGS)
{
  FuncCallContext *funcctx;
  TupleDesc        tupdesc;
  TupleTableSlot  *slot;
  AttInMetadata   *attinmeta;
  fcetab_info     *fceinfo;

  if (SRF_IS_FIRSTCALL ())
    {
      MemoryContext oldcontext;
      funcctx = SRF_FIRSTCALL_INIT ();
      oldcontext = MemoryContextSwitchTo (funcctx -> multi_call_memory_ctx);

      tupdesc = RelationNameGetTupleDesc ("_time_series3");
      slot = TupleDescGetSlot (tupdesc);
      funcctx -> slot = slot;

      attinmeta = TupleDescGetAttInMetadata (tupdesc);
      funcctx -> attinmeta = attinmeta;

      fceinfo = (fcetab_info*) palloc (sizeof (fcetab_info));

      bytea *ba = PG_GETARG_BYTEA_P (0);
      fceinfo -> length  = (VARSIZE(ba) - VARHDRSZ - sizeof(int)) / sizeof (float) ;
      fceinfo -> current = (float*)VARDATA(ba);
      fceinfo -> row     = 1;
      fceinfo -> cols    = *(int*)fceinfo -> current++;
      fceinfo -> length /= fceinfo -> cols;

      fceinfo -> ts1     = PG_GETARG_INT32 (1) - 1;
      fceinfo -> ts2     = PG_GETARG_INT32 (2) - 1;
      fceinfo -> ts3     = PG_GETARG_INT32 (3) - 1;

      if (fceinfo -> ts1 < 0 || fceinfo -> ts1 >= fceinfo -> cols)
	elog(ERROR, "tseries index one is out of value.");	
      if (fceinfo -> ts2 < 0 || fceinfo -> ts2 >= fceinfo -> cols)
	elog(ERROR, "tseries index two is out of value.");	
      if (fceinfo -> ts3 < 0 || fceinfo -> ts3 >= fceinfo -> cols)
	elog(ERROR, "tseries index three is out of value.");	

      fceinfo -> values = (char **) palloc (4 * sizeof (char *));
      fceinfo -> values [0] = (char*) palloc (16 * sizeof (char));
      fceinfo -> values [1] = (char*) palloc (16 * sizeof (char));
      fceinfo -> values [2] = (char*) palloc (16 * sizeof (char));
      fceinfo -> values [3] = (char*) palloc (16 * sizeof (char));

      funcctx -> user_fctx = (void*) fceinfo;
      
      MemoryContextSwitchTo (oldcontext);
    }

  funcctx = SRF_PERCALL_SETUP ();
  fceinfo = (fcetab_info*) funcctx -> user_fctx;

  if (fceinfo->length--)
    {
      Datum result; HeapTuple tuple;

      snprintf (fceinfo -> values [0], 16, "%d", ( fceinfo -> row++));
      snprintf (fceinfo -> values [1], 16, "%f", *(fceinfo -> current + fceinfo -> ts1));
      snprintf (fceinfo -> values [2], 16, "%f", *(fceinfo -> current + fceinfo -> ts2));
      snprintf (fceinfo -> values [3], 16, "%f", *(fceinfo -> current + fceinfo -> ts3));

      if (fceinfo -> length)
	fceinfo -> current += fceinfo -> cols; 
      
      tuple = BuildTupleFromCStrings (funcctx -> attinmeta, fceinfo -> values);
      result = TupleGetDatum (funcctx -> slot, tuple);

      SRF_RETURN_NEXT (funcctx, result);
    }
  else
    {
      SRF_RETURN_DONE (funcctx);
    }
}











