#!/usr/bin/env bash
# setup primary-standby cluster, shutdown primary, flip checksum state, see if standby works, verify checksums on standby

set -e

SCALE=$1
DATADIRS=/mnt/raid-nvme
DURATION=3600

DATA=$DATADIRS/pitr/data
WAL=$DATADIRS/pitr/wal
BACKUPS=$DATADIRS/pitr/backups

TS=$(date +%Y%m%d-%H%M%S)

mkdir $TS

killall -9 postgres || true

rm -Rf $DATA

rm -Rf $DATADIRS/pitr
mkdir -p $BACKUPS $WAL

pg_ctl -D $DATA init > $TS/init.log 2>&1

echo 'max_wal_size = 16GB' >> $DATA/postgresql.conf
echo "archive_mode = on" >> $DATA/postgresql.conf
echo "archive_command = 'cp %p $WAL/%f'" >> $DATA/postgresql.conf

pg_ctl -D $DATA -l $TS/pg.log start 2>&1

createdb test
pgbench -i -s $SCALE test > $TS/pgbench.init.log 2>&1

# run pgbench in the background
pgbench -N -c 16 -T $DURATION test > $TS/pgbench.log 2>&1 &

# also run checksums flipping in the background
./checksums-flip-fast.sh $TS $DURATION > $TS/checksums.log 2>&1 &

s=$(date +%s)
e=$((s + DURATION))

mode="fast"

while /bin/true; do

	sleep 1

	ID=$(date +%Y%m%d%H%M%S)

	# throttle the basebackup, to allow multiple on/off checksum flips
	pg_basebackup -r 10M -c $mode -D $BACKUPS/$ID > $TS/basebackup.$ID.log 2>&1

	s=$(date +%s)

	if [ $s -gt $e ]; then
		break
	fi

	# flip checkpoint mode
	if [ "$mode" == "fast" ]; then
		mode="spread"
	else
		mode="fast"
	fi

done

pg_ctl -D $DATA -l $TS/pg.log stop
