#!/usr/bin/env bash
# setup primary-standby cluster, shutdown primary, flip checksum state, see if standby works, verify checksums on standby

set -e
#set -x

ID=$1
DATADIRS=/mnt/raid-nvme

DATA=$DATADIRS/data-validate
BACKUPS=$DATADIRS/pitr/backups

rm -Rf $DATA

cp -R $BACKUPS/$ID $DATA

echo "port = 5555" >> $DATA/postgresql.conf

pg_ctl -D $DATA -l pg.$ID.log start > /dev/null 2>&1
pg_ctl -D $DATA stop > /dev/null 2>&1

v=$(pg_controldata $DATA | grep 'Data page checksum version' | awk '{print $5}')

if [ "$v" == "1" ]; then
	c=$(pg_checksums --check $DATA | tee checksums.$ID.log | grep 'Bad checksums' | awk '{print $3}')

	if [ "$c" == "0" ]; then
		echo ON $c
	else
		echo ON $c ERROR
	fi
else
	echo OFF -1
fi
