/*
 * has_priv.h
 *
 * Check for user privileges
 *
 * Copyright (c) Joseph Conway <joe.conway@mail.com>, 2001;
 * Licence: BSD
 *
 */

#ifndef HAS_PRIV_H
#define HAS_PRIV_H

#include <string.h>
#include <ctype.h>
#include "postgres.h"
#include "access/heapam.h"
#include "fmgr.h"
#include "utils/acl.h"
#include "utils/builtins.h"
#include "utils/syscache.h"
#include "catalog/pg_shadow.h"

#include "storage/proc.h"
#include "catalog/catname.h"
#include "utils/fmgroids.h"
#include "catalog/pg_database.h"

static char *str_toupper(char *buff);

extern Datum has_privilege(PG_FUNCTION_ARGS);

#define PRIV_INSERT			"INSERT\0"
#define PRIV_SELECT			"SELECT\0"
#define PRIV_UPDATE			"UPDATE\0"
#define PRIV_DELETE			"DELETE\0"
#define PRIV_RULE			"RULE\0"

#endif	 /* HAS_PRIV_H */
