/*-------------------------------------------------------------------------
 *
 * variadic_demo.c
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"
#include "fmgr.h"
#include "utils/lsyscache.h"

PG_MODULE_MAGIC;

PG_FUNCTION_INFO_V1(variadic_demo);

Datum variadic_demo(PG_FUNCTION_ARGS);

Datum
variadic_demo(PG_FUNCTION_ARGS)
{
	int	i;
	
	for (i = 0; i < fcinfo->nargs; i++)
	{
		Oid	valtype;
		Datum	value;
		Oid	typoutput;
		bool		typIsVarlena;

		if (PG_ARGISNULL(i))
			elog(NOTICE, "arg(%d) is null", i);
		else
		{
			value = PG_GETARG_DATUM(i);
			valtype = get_fn_expr_argtype(fcinfo->flinfo, i);
			getTypeOutputInfo(valtype, &typoutput, &typIsVarlena);
			elog(NOTICE, "arg(%d) = %s", i, OidOutputFunctionCall(typoutput, value));
		}
	}
	PG_RETURN_VOID();
}
