#include "postgres.h"
#include "fmgr.h"
#include "lib/stringinfo.h"
#include "utils/builtins.h"
#include "utils/lsyscache.h"

PG_MODULE_MAGIC;

PG_FUNCTION_INFO_V1(postgresql_sprintf);

Datum		postgresql_sprintf(PG_FUNCTION_ARGS);

Datum
postgresql_sprintf(PG_FUNCTION_ARGS)
{
	char	   *fmt = PG_GETARG_CSTRING(0);
	StringInfo	str;
	char		*cp;
	int			i = 1;

	if (PG_ARGISNULL(0))
		PG_RETURN_NULL();
	
	str = makeStringInfo();
	
	for (cp = fmt; *cp; cp++)
	{
		if (cp[0] == '%')
		{
			Oid	valtype;
			Datum	value;
			Oid                     typoutput;
			bool            typIsVarlena;
			        
		
			if (cp[1] == '%')
			{
				appendStringInfoChar(str, cp[1]);
				cp++;
				continue;
			}
			
			if (i > PG_NARGS())
				elog(ERROR, "too few parameters specified by format string");
			
			if (PG_ARGISNULL(i))
			{
				appendStringInfoString(str, "NULL");
			}
			else
			{
				/* append n-th value */
				value = PG_GETARG_DATUM(i);
				valtype = get_fn_expr_argtype(fcinfo->flinfo, i);
				
				getTypeOutputInfo(valtype, &typoutput, &typIsVarlena);
				appendStringInfoString(str, OidOutputFunctionCall(typoutput, value));
			}
			i++;
		}
		else
			appendStringInfoChar(str, cp[0]);
	}
	
	if (i != PG_NARGS())
		elog(ERROR, "too much parameters");
	
	PG_RETURN_TEXT_P(CStringGetTextDatum(str->data));
}

