CREATE OR REPLACE FUNCTION change_account_balance(key INT, delta NUMERIC) RETURNS VOID AS
$$
BEGIN
    LOOP
        -- first try to update the key
        UPDATE pgbench_accounts SET abalance = abalance + delta WHERE aid = key;
        IF found THEN
            RETURN;
        END IF;
        -- not there, so try to insert the key
        -- if someone else inserts the same key concurrently,
        -- we could get a unique-key failure
        BEGIN
            INSERT INTO pgbench_accounts(aid,bid,abalance) VALUES (key,1+(key / 100000)::integer,delta);
            RETURN;
        EXCEPTION WHEN unique_violation THEN
            -- do nothing, and loop to try the UPDATE again
        END;
    END LOOP;
END;
$$
LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION merge_account_balance(key INT, delta NUMERIC) RETURNS VOID AS
$$
BEGIN
MERGE INTO pgbench_accounts t USING (SELECT * FROM pgbench_accounts WHERE aid = key) AS s ON t.aid=s.aid WHEN MATCHED THEN UPDATE SET abalance = s.abalance + delta WHEN NOT MATCHED THEN INSERT VALUES (key,1+(key / 100000)::integer,delta,'');
END;
$$
LANGUAGE plpgsql;

