#! /bin/sh
r=`pwd`
d0="$r/d0"
d1="$r/d1"
a0="$r/a0"
a1="$r/a1"
p0="5532"
p1="5432"

killall postgres
rm -rf $d0 $d1 $a0 $a1
mkdir -p $d0 $d1 $a0 $a1
chmod 700 $d0 $d1 $a0 $a1

initdb -D $d0
cat >> $d0/postgresql.conf <<EOF
port = $p0
wal_level = hot_standby
max_wal_senders = 2
checkpoint_segments = 2
checkpoint_timeout = 30s
archive_mode = on
archive_command = 'cp %p $a0/%f'
#log_checkpoints = on
log_line_prefix='[0] %m '
EOF
cat >> $d0/pg_hba.conf <<EOF
local   replication     all                                trust
EOF
pg_ctl -D $d0 -w start

pg_basebackup -D $d1 -h /tmp -p $p0
cat >> $d1/postgresql.conf <<EOF
port = $p1
log_line_prefix='[1] %m '
EOF
cat > $d1/recovery.conf <<EOF
standby_mode='yes'
recovery_target_timeline='latest'
restore_command='cp $a0/%f %p'
primary_conninfo='host=/tmp port=$p0'
EOF

pg_ctl -D $d1 start
sleep 5
pg_ctl -D $d1 stop -m f
sleep 1
pg_ctl -D $d0 stop -m i
sleep 5

cat > $d0/recovery.conf <<EOF
standby_mode='yes'
recovery_target_timeline='latest'
restore_command='cp $a0/%f %p'
primary_conninfo='host=/tmp port=$p1'
EOF

pg_ctl -D $d0  start
sleep 5
pg_ctl -D $d0 -w promote
sleep 5

psql -p $p0 postgres -c "create table t (a int)"
psql -p $p0 postgres -c "insert into t select a from generate_series(1, 2000000) a; delete from t; select pg_current_xlog_location()"

pg_ctl -D $d0 -w stop -m i

cat > $d0/recovery.conf <<EOF
standby_mode='yes'
recovery_target_timeline='latest'
restore_command='cp $a0/%f %p'
primary_conninfo='host=/tmp port=$p1'
EOF
pg_ctl -D $d0 start
sleep 5
pg_ctl -D $d0 -w promote
sleep 5
pg_ctl -D $d1 start
