#!/bin/bash
#
# This test script reproduces the bug reported here:
#
# http://www.postgresql.org/message-id/529DED09.3080501@vmware.com
#
# To use, set up a test server with initdb, and point MASTERDATADIR to it.
# Install pg_trgm extension, and set up the server for streaming replication
# Then run this script. It will create a test table and GIN index, take a
# backup, modify the index while the backup is running, and then finish
# the backup. The backup will then be further jumbled to contain bytes from
# two versions of the data directory (both copies taken while the backup
# was in progress), basically creating a lot of very torn pages.
# Finally, start a (hot standby) server from "data-after" directory, and
# run a query against the test table:
#
#  select * from foo where t % 'foo';
#
# It should run OK, but return no rows. If the bug is present, it will crash,
# fail an assertion, or enter an infinite loop instead.
#

set -e

MASTERDATADIR=/home/heikki/pgsql.master/data
PATH=/home/heikki/pgsql.master/bin:$PATH

rm -rf data-before data-after

# SETUP
psql -f test-setup.sql postgres

psql -c "select pg_start_backup('fuzztest', true)" postgres

# copy the data directory
cp --reflink=auto -a $MASTERDATADIR data-before
rm -rf data-before/pg_xlog/*
rm -f data-before/postmaster.pid

# DO STUFF
psql -f test-run.sql postgres

# make another copy of the data directory
cp --reflink=auto -a $MASTERDATADIR data-after
rm -rf data-after/pg_xlog/*
rm -f data-after/postmaster.pid

psql -c "select pg_stop_backup()" postgres

cat > data-after/recovery.conf <<EOF
primary_conninfo=''
standby_mode='on'
EOF

python fuzzbackup.py -b data-before -a data-after

# Don't modify the control file. We assume the write of the control file
# to be atomic. That assumption is questionable, but if we try to jumble
# it, all you get is a checksum error.
cp data-before/global/pg_control data-after/global/

