#!/bin/bash

#
# Test runner
# Simulation pg_toast problem with custom type in postgres
# @author Jan Pecek <honzap@gmail.com>
#

# vars
DB_NAME="foo"
TEST_FILE="test-string.txt"


# input ceheck
[ ! -f "${TEST_FILE}" ] && {
	echo "Could not found file with test string '${TEST_FILE}'!"
	exit 2
}

TEXT=`cat "${TEST_FILE}"`

for chr in {a..z}; do 
	# Changing letters in text
	TEXT=`echo -n "${TEXT}" | sed -e "s/$chr/@/g"`
	SQL="UPDATE foo SET description = '`echo -n $TEXT`' WHERE id = 1;"
	echo -n "Round '${chr}'..."
	psql -c "${SQL}" "${DB_NAME}" > /dev/null
	echo -n "Update OK..."
	# Wait until someone/something process the record - it's necessary to update it
	sleep 60
	psql -c "UPDATE foo_journal SET processed = NOW() WHERE foo_id = 1 AND processed IS NULL;" "${DB_NAME}" > /dev/null
	echo "Confirmed OK."
	echo -n "Waiting 5 minutes..."
	# Wait some time (for auto-vacuum or sth. like that)
	sleep 300
	echo "OK, next round, try to make a select from 'foo_journal' table."
	# Try to select from table (fails on selecting changes column)
	psql -c "SELECT * FROM foo_journal" "${DB_NAME}" > /dev/null || exit 1
done

echo "Done"

exit 0;

