<?php

/**
 * Example use of the Calendar class
 * Copyright (c): 1999-2000 ispi, all rights reserved

 * This source file is subject to version 2.02 of the PHP license,
 * that is bundled with this package in the file LICENSE, and is
 * available at through the world-wide-web at
 * http://www.php.net/license/2_02.txt.
 * If you did not receive a copy of the PHP license and are unable to
 * obtain it through the world-wide-web, please send a note to
 * license@php.net so we can mail you a copy immediately.
 *
 * Copyright (c) 1999, 2000 ispi
 *
 * @access public
 *
 * @version 1.1
 * @author Monte Ohrt <monte@ispi.net>
 */

if($source == "pretty")
{
	show_source($SCRIPT_FILENAME);
	exit();
}
elseif($source == "plain")
{
	header("Content-type: text/plain");
	readfile($SCRIPT_FILENAME);
	exit();
}

require("Calc.php");

$year = "2000"; 
if(Date_Calc::isLeapYear($year))
	echo "$year is leap year<br>\n";
else
	echo "$year is not leap year<br>\n";

if(Date_Calc::isFutureDate("29","09","2000"))
	echo "is future date<br>\n";
else
	echo "is not future date<br>\n";

if(Date_Calc::isPastDate("27","08","2000"))
	echo "is past date<br>\n";
else
	echo "is not past date<br>\n";
		 
		 		 
echo "julian days is ".Date_Calc::julianDate()."<br>\n";

echo "day of week is ".Date_Calc::dayOfWeek("01","02","2000")."<br>\n";

echo "week of year is ".Date_Calc::weekOfYear("02","09","2000")."<br>\n";

echo "quarter of year is ".Date_Calc::quarterOfYear()."<br>\n";

echo "begin of next month is ".Date_Calc::beginOfNextMonth()."<br>\n";
echo "end of next month is ".Date_Calc::endOfNextMonth()."<br>\n";
echo "begin of prev month is ".Date_Calc::beginOfPrevMonth()."<br>\n";
echo "end of prev month is ".Date_Calc::endOfPrevMonth()."<br>\n";


$days = Date_Calc::dateToDays("13","10","2000");
echo "date to days is $days<br>\n";

$tmpdate = Date_Calc::daysToDate($days,"%Y/%m/%d");
echo "days to date is $tmpdate<br>\n";

echo "next week day is ".Date_Calc::nextWeekday()."<br>\n";
echo "prev week day is ".Date_Calc::prevWeekday()."<br>\n";

echo "the next sunday from today occurs on ".Date_Calc::nextDayOfWeek(0)."<br>\n";
echo "the prev sunday from today occurs on ".Date_Calc::prevDayOfWeek(0)."<br>\n";

echo "the next sunday on or from today occurs on ".Date_Calc::nextDayOfWeekOnOrAfter(0)."<br>\n";
echo "the prev sunday on or from today occurs on ".Date_Calc::prevDayOfWeekOnOrBefore(0)."<br>\n";


echo "the next day is ".Date_Calc::nextDay()."<br>\n";
echo "the prev day is ".Date_Calc::prevDay()."<br>\n";

echo "date diff is ".Date_Calc::dateDiff("28","09","2000","28","09","2001")."<br>\n";

echo "default century for 99 is ".Date_Calc::defaultCentury(99)."<br>\n";

echo "days in month is ".Date_Calc::daysInMonth()."<br>\n";

echo "first weekday of month is ".Date_Calc::firstOfMonthWeekday(11,2000)."<br>\n";

echo "begin of month is ".Date_Calc::beginOfMonth()."<br>\n";

echo "begin of week is ".Date_Calc::beginOfWeek()."<br>\n";
echo "end of week is ".Date_Calc::endOfWeek()."<br>\n";

echo "begin of next week is ".Date_Calc::beginOfNextWeek()."<br>\n";
echo "begin of prev week is ".Date_Calc::beginOfPrevWeek()."<br>\n";

if(Date_Calc::isValidDate("2","2","2000"))
		echo "date is valid\n";
else
		echo "date is not valid\n";

echo "first day of week is ".Date_Calc::beginOfWeek("20","08","2000")."<br>\n";
echo "last day of week is ".Date_Calc::endOfWeek("27","08","2000")."<br>\n";

echo "weekday abbr is ".Date_Calc::getWeekdayAbbrname("01","01","2000",2)."<br>\n";


echo "The third monday of September, 2000 is: ".Date_Calc::NWeekdayOfMonth(3,1,"09","2000","%Y/%m/%d<br>");

echo "<p> calendar week:<br>";

$week = Date_Calc::getCalendarWeek("01","01","2001");

for($curr_day=0; $curr_day < count($week); $curr_day++)
{
	echo $week[$curr_day]." ";
}

echo "<p> calendar month: (with format %b)<br>";

$month = Date_Calc::getCalendarMonth("11","2000","%b");

for($row = 0; $row < count($month); $row++)
{
	for($col=0; $col <7; $col++)
	{
			echo $month[$row][$col]." \n";
	}
	echo "<br>\n";
}

echo "<p> calendar year:<br>";

$year = Date_Calc::getCalendarYear("2000");

for($curr_month = 0; $curr_month < count($year); $curr_month++)
{


	for($row = 0; $row < count($year[$curr_month]); $row++)
	{
		for($col=0; $col <7; $col++)
		{
				echo $year[$curr_month][$row][$col]." \n";
		}
		echo "<br>\n";
	}
	
	echo "<p>\n";
		
}
		
?>

<P>
show source
<A href="test.php?source=plain">Plain</A>			
<A href="test.php?source=pretty">Pretty</A>			
</P>
