
#include <gtkmm.h>
#include <plplot/plstream.h>

#include <iostream>

class tclip
	: public Gtk::DrawingArea
{
public:

	tclip(const char* ori, const std::string& title)
		: pls_()
		, title_(title)
		, dirty_(true)
	{
		pls_.sdev("extcairo");
		pls_.setopt("ori", ori);
		pls_.init();
	}

	bool on_expose_event(GdkEventExpose* /*event*/)
	{

		Glib::RefPtr<Gdk::Window> window = get_window();

		if(window) {
			Cairo::RefPtr<Cairo::Context> cr = window->create_cairo_context();

			// Just a sample to show it's possible to draw with both plplot and
			// cairo on the same context.
			cr->select_font_face("Sans", Cairo::FONT_SLANT_NORMAL,
					Cairo::FONT_WEIGHT_NORMAL);
			cr->set_font_size(12.0);

			cr->move_to(10.0, 15.0);
			cr->show_text(title_);

#if 0
			// Always fitting causes problems with partial redraws since the
			// graph gets scaled to the "dirty rect". This can be seen when
			// overlaying the widget partially on the left side only. A smaller
			// scalled version of the plot will be drawn on the dirtied area.
			pls_.cmd(PLESC_DEVINIT_FIT, cr->cobj());
			pls_.env(0.0, 4.0, 0.0, 1.0, 1, 0);
			pls_.lab("x", "y", "title");
#else
			double x1, y1, x2, y2;
			cr->get_clip_extents(x1, y1, x2, y2);

			// When the entire area is "dirty" one of the following occured
			// - The area is drawn the first time
			// - The area is resized
			// - The area is dirtied by an overlaying window, showing after
			//   minimizing etc.
			// The first case needs all redraw, the others need a refresh.
			// Both the resizing and the non-resizing are treated the same,
			// but needs further testing whether it gives problems. This
			// testing can be one after the PLESC_RESIZE works properly.
			if(x1 == 0 && y1 == 0 && x2 == get_width() && y2 == get_height()) {
				if(dirty_) {
#if 0
					// The resize doesn't scale as wanted so manually redraw.
					dirty_ = false;
#endif
					pls_.cmd(PLESC_DEVINIT_FIT, cr->cobj());
					pls_.env(0.0, 4.0, 0.0, 1.0, 1, 0);
					pls_.lab("x", "y", "title");
				} else {
					pls_.cmd(PLESC_RESIZE, cr->cobj());
				}
			} else {
				pls_.cmd(PLESC_REDRAW, cr->cobj());
			}
#endif
		}
		return true;
	}
private:
	plstream pls_;

	std::string title_;

	bool dirty_;
};

class tgeometry
	: public Gtk::DrawingArea
{
public:

	tgeometry(const std::string& ori, const std::string& title)
		: ori_(ori)
		, title_(title)
	{
	}

	bool on_expose_event(GdkEventExpose* /*event*/)
	{

		Glib::RefPtr<Gdk::Window> window = get_window();

		if(window) {
			plstream pls;

			pls.sdev("extcairo");

			std::stringstream sstr;
			sstr << get_width() << 'x' << get_height();

			pls.setopt("geometry", sstr.str().c_str());
			pls.setopt("ori", ori_.c_str());
			pls.init();

			Cairo::RefPtr<Cairo::Context> cr = window->create_cairo_context();

			cr->select_font_face("Sans", Cairo::FONT_SLANT_NORMAL,
					Cairo::FONT_WEIGHT_NORMAL);
			cr->set_font_size(12.0);

			cr->move_to(10.0, 15.0);
			cr->show_text(title_);

			pls.cmd(PLESC_DEVINIT, cr->cobj());

			pls.env(0.0, 4.0, 0.0, 1.0, 1, 0);
			pls.lab("x", "y", "title");

		}
		return true;
	}

private:
	std::string ori_;

	std::string title_;
};

int main(int argc, char **argv)
{
	Gtk::Main kit(argc, argv);

	tgeometry geometry0("0", "Using geometry, ori 0");
	tgeometry geometry1("1", "Using geometry, ori 1");
	Gtk::HPaned geometry;
	geometry.set_position(400);
	geometry.add1(geometry0);
	geometry.add2(geometry1);


	tclip clip0("0", "Using clip extents, ori 0");
	tclip clip1("1", "Using clip extents, ori 1");
	Gtk::HPaned clip;
	clip.set_position(400);
	clip.add1(clip0);
	clip.add2(clip1);

	Gtk::VPaned vpane;
	vpane.set_position(300);
	vpane.add1(geometry);
	vpane.add2(clip);

	Gtk::Window window;
	window.set_size_request(800, 600);
	window.add(vpane);
	window.show_all();

	Gtk::Main::run(window);
}
