#define C1 (1.0)
#define C2 (-15e-3)
#define C3 (30.0)

float comp(float val2_f, float val1_f) {

  float dt, x;
  float n, d;
  
  dt = val1_f - C3;
  x = 320e-9 * dt + 80e-6;
  x = x * dt - 15e-3;
  
  n = val2_f - C1 * ((x * dt) - C2);
  d = (1.0 - 3.1e-3 * C1 * (val1_f - C3));
  
  n = n/d;
  
  if (val1_f < 0.0) {
    d = (1.0 - (60.6e-6 * val1_f * val1_f * C1));	
    n = n/d;
  }
  
  return n;
}
