#include "comp.h"
#include "regs.h"

#define	ADD_T_real 27315.0
#define	MUL_T_real   100.0
#define	MUL_F_real   100.0
#define DIV_F_real (1.0 / MUL_F_real)
#define DIV_T_real (1.0 / MUL_T_real)

REGS_t *p_regs = (REGS_t * const) 0x0;

int main(void) {
  float f_val1;
  float f_val2;
  
  f_val1 = (float) p_regs->ui_val1;
  f_val2 = (float) p_regs->ui_val2;
  
  f_val1 *= (ADD_T_real * DIV_T_real); 
  f_val2 *= DIV_F_real;
  
  f_val2 = comp(f_val2, f_val1);
   
  p_regs->val1 = (int16_t) (f_val1 * MUL_T_real + ADD_T_real);
  p_regs->val2 = (int16_t) (f_val2 * MUL_F_real);
  
  return 0;
}
