# Documentation string. I wonder what ever refers to it? 

__doc__ = """JWFind"""

__version__ = '0.1'

from Globals import HTMLFile, MessageDialog, Persistent

import OFS.SimpleItem
import Acquisition
import AccessControl.Role

from Person import Person

manage_addJWFindForm = HTMLFile('jwfindAdd', globals())

def manage_addJWFind(self, id, title='', REQUEST=None):
    """Add a JWFind to a folder."""
    self._setObject(id, JWFind(id, title))
    if REQUEST is not None:
        return self.manage_main(self, REQUEST)

class JWFind(
    OFS.SimpleItem.Item,   # A simple Principia object. Not Folderish.
    Persistent,            # Make us persistent. Yaah!
    Acquisition.Implicit,  # Uh, whatever.
    AccessControl.Role.RoleManager # Security manager.
    ): 
    """JWFind object, from scratch instead of ZClasses."""

    meta_type = 'JWFind'

    manage_options = (
	{'label': 'Edit',       'action': 'manage_main'},
	{'label': 'View',       'action': ''}, # defaults to index_html
	{'label': 'Security',   'action': 'manage_access'},
        ) 

    __ac_permissions__ = (
	('View management screens', ('manage_tabs','manage_main')),
	('Change permissions',      ('manage_access',)           ),
	('Change JWFinds'     ,     ('manage_edit',)             ),
	('View JWFinds',            ('',)                        ),
	)

    def __init__(self, id, title=''):
        """initialise a new instance of JWFind"""
        self.id = id
        self.title = title

#    index_html = HTMLFile('index', globals()) # View Interface
    def index_html(self, REQUEST=None):
	"""JWFind Form"""
#	out = '<html><head></head><body>aaa</body></html>'
	out = Person(self, REQUEST)()
	return out.PersonView
    
    manage_main = HTMLFile('jwfindEdit', globals()) # Management Interface
    
    def manage_edit(self, title, REQUEST=None):
        """edit"""
        self.title = title
	if REQUEST is not None:
	    return MessageDialog(
		title = 'Edited',
		message = "Properties for %s changed." % self.id,
		action = './manage_main',
		)
