__doc__ = """JWFind initialization module."""
__version__ = '0.1'

import JWFind

def initialize(context):
    """Register the JWFind product."""
    try:
        context.registerClass(
            JWFind.JWFind,
            constructors = (
                JWFind.manage_addJWFindForm, # when someone adds the product
                JWFind.manage_addJWFind),    # named, so we can give permissions to call
            icon = 'item.gif'
            )
    except:
        """Tell about troubles, assuming you're running Zope in debug mode."""
        import sys, traceback, string
        type, val, tb = sys.exc_info()
        sys.stderr.write(string.join(traceback.format_exception(type, val, tb), ''))
        del type, val, tb
