
def pytest_funcarg__mysetup(request):
    mysetup = request.cached_setup(
        setup=lambda: MySetup(),
        teardown=lambda mysetup: mysetup.global_teardown(),
        scope="session",
    )
    request.cached_setup(
        setup=lambda: mysetup.group_setup(request.module),
        teardown=lambda group: mysetup.group_teardown(request.module),
        scope="module",
    )
    request.cached_setup(
        setup=lambda: mysetup.setup(),
        teardown=lambda mytest: mysetup.teardown(),
        scope="function"
    )
    return mysetup
   
class MySetup:
    def __init__(self):
        self.global_setup()

    def global_setup(self):
        log("global_setup()")

    def global_teardown(self):
        log("global_teardown()")

    def group_setup(self, module):
        log("  group_setup(%r)"  % (module.__name__,))

    def group_teardown(self, module):
        log("  group_teardown(%r)"  % (module.__name__,))

    def setup(self):
        log("    setup()")

    def teardown(self):
        log("    teardown()")


# the below only for logging setup meta information to a file 
f = None
def log(msg):
    global f
    if not f:
        f = open('setup.log', 'w')
    f.write(msg.rstrip()+"\n")
    f.flush()
