import Qt 4.7

Rectangle {
    id: list
    color: "#343434"
    width: 200
    height: 400
    
    Component {
        id: listDelegate
        ListItem {
            id: listItem
            title: model.item.title

            ListView.onRemove: SequentialAnimation {
                PropertyAction { target: listItem; property: "ListView.delayRemove"; value: true }
                NumberAnimation { target: listItem; property: "height"; to: 0; duration: 250; easing.type: Easing.InOutQuad }
                PropertyAction { target: listItem; property: "ListView.delayRemove"; value: false }
            }
        }
    }
                                                                    
    ListView {
        id: listView
        clip: true
        anchors.fill: parent
        anchors.bottomMargin: 100
        model: listModel
        delegate: listDelegate
        highlightFollowsCurrentItem: true
        highlightMoveDuration: 2000
        focus: true
    }
        
    TextButton {
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.bottomMargin: 20
        anchors.leftMargin: 10
        width: 80
        height: 40
        text: "Reduce"
        onClicked: controller.reduce()
    }

    TextButton {
        anchors.bottom: parent.bottom
        anchors.right: parent.right
        anchors.bottomMargin: 20
        anchors.rightMargin: 10
        width: 80
        height: 40
        text: "All"
        onClicked: controller.showAll()
    }
}
