import Qt 4.7

Item {
    id: listItem
    property string title
    property double itemHeight: 60
    anchors.right: parent.right
    anchors.left: parent.left
    height: itemHeight

    Rectangle {
        id: frame
        anchors.fill: parent
        anchors.rightMargin: 5
        anchors.leftMargin: 5
        anchors.topMargin: 5
        anchors.bottomMargin: 5
        color: "#00000000"
        radius: 20
        border.width: 2
        border.color: "#ffffff"
        
        MouseArea {
            id: itemMouseArea
            anchors.fill: parent
            onClicked: {
                listView.currentIndex = index
            }
        }
    
        Text {
            id: titleText
            color: "#ffffff"
            text: listItem.title
            anchors.fill: parent
            anchors.leftMargin: 10
            clip: false
            elide: Text.ElideRight
            verticalAlignment: Text.AlignVCenter
            font.pointSize: 20
            focus: true
        }

    }

    states: [
        State {
            name: "Current"
            when: listItem.ListView.isCurrentItem && !listItem.selected
            PropertyChanges { target: frame; border.color: "#ffff00" }
            PropertyChanges { target: titleText; color: "#ffff00" }
        }
    ]

    transitions: [
        Transition {
            from: "*"; to: "*"
            ColorAnimation { duration: 500 }
        }
    ]
}
