import Qt 4.7

Item {
    id: container
    signal clicked
    property string color: "#ffffff"
    property string text
    property int radius: 10
    property int textSize: 18
 
    Rectangle {
        id: buttonRectangle
        anchors.fill: parent
        color: "#00000000"
        radius: container.radius
        border.width: 2
        border.color: "#ffffff"

        MouseArea {
            id: mouseArea
            anchors.fill: parent
            onClicked: {
                buttonRectangle.state = "pressed"
                stateTimer.start()            
                container.clicked()
            }
        }
 
        Text {
            color: container.color
            anchors.centerIn: buttonRectangle
            font.pixelSize: container.textSize
            text: container.text
            font.bold: true
        }
 
        states: State {
            name: "pressed"
            PropertyChanges { target: buttonRectangle; scale: 0.7 }
        }
 
        Timer {
            id: stateTimer
            interval: 200;
            repeat: false
            onTriggered: buttonRectangle.state = 'State0'
        }

        transitions: Transition {
            NumberAnimation { properties: "scale"; duration: 200; easing.type: Easing.InOutQuad }
        }
    }
}
