from PySide import QtCore, QtGui, QtDeclarative
import sys

class PyToQml(QtCore.QObject):

    def __init__(self,rootContext):
        QtCore.QObject.__init__(self)
        self.listModel = self.ListModel([])
        self.controller = Controller(self)               
        rootContext.setContextProperty('controller', self.controller)
        rootContext.setContextProperty('listModel', self.listModel)
        self.listItems = []
        for i in range(5):
            self.listItems.append(self.ListItem("Item "+str(i)))
        self.listModel.addItems(self.listItems)
        
    class ListItem(QtCore.QObject):
    
        def __init__(self, item):
            QtCore.QObject.__init__(self)
            self.item = item
    
        def _title(self):
            return self.item
    
        changed = QtCore.Signal()
    
        title = QtCore.Property(unicode, _title, notify=changed)
                
    class ListModel(QtCore.QAbstractListModel):
        COLUMNS = ('item',)
    
        def __init__(self, items):
            QtCore.QAbstractListModel.__init__(self)
            self._items = items
            self.setRoleNames(dict(enumerate(self.COLUMNS)))
    
        def rowCount(self, parent=QtCore.QModelIndex()):
            return len(self._items)
    
        def data(self, index, role):
            print "data read", index, self.rowCount()
            if index.isValid() and role == self.COLUMNS.index('item'):
                return self._items[index.row()]
            return None
            
        def removeRow(self, row, parent=QtCore.QModelIndex()):
            self.beginRemoveRows(QtCore.QModelIndex(), row, row)
            del self._items[row]
            self.endRemoveRows()

        def removeRows(self, firstRow, rowCount, parent=QtCore.QModelIndex()):
            print "delete", firstRow, firstRow+rowCount-1
            self.beginRemoveRows(QtCore.QModelIndex(), firstRow, firstRow+rowCount-1)
            while rowCount != 0:
                del self._items[firstRow]
                rowCount -= 1
            self.endRemoveRows()
            
        def moveRowUp(self, index):
            tempItem = self._items[index-1]
            self.beginMoveRows(QtCore.QModelIndex(), index, index, QtCore.QModelIndex(), index-1)
            del self._items[index-1]
            self._items.insert(index, tempItem)
            self.endMoveRows()

        def moveRowDown(self, index):
            tempItem = self._items[index+1]
            self.beginMoveRows(QtCore.QModelIndex(), index+1, index+1, QtCore.QModelIndex(), index)
            del self._items[index+1]
            self._items.insert(index, tempItem)
            self.endMoveRows()

        def addItem(self, item):
            self.beginInsertRows(QtCore.QModelIndex(), len(self._items), len(self._items))
            self._items.append(item)
            self.endInsertRows()
            
        def addItems(self, items):
            print "add", len(self._items), len(self._items)+len(items)-1
            self.beginInsertRows(QtCore.QModelIndex(), len(self._items), len(self._items)+len(items)-1)
            for i in items:
                self._items.append(i)
            self.endInsertRows()
            
        def replaceItems(self, items):
            print "replace", len(self._items), len(items)
            self.removeRows(0,len(self._items))        
            self.beginInsertRows(QtCore.QModelIndex(), 0, len(items)-1)
            self._items = items
            self.endInsertRows()

class Controller(QtCore.QObject):
    def __init__(self, mainClass):
        QtCore.QObject.__init__(self)
        self.mainClass = mainClass
    
    @QtCore.Slot()
    def reduce(self):
        items = [self.mainClass.listItems[0], self.mainClass.listItems[1]]
        self.mainClass.listModel.replaceItems(items)

    @QtCore.Slot()
    def showAll(self):
        items = [self.mainClass.listItems[0], self.mainClass.listItems[1], self.mainClass.listItems[2], self.mainClass.listItems[3], self.mainClass.listItems[4]]
        self.mainClass.listModel.replaceItems(items)

if __name__ == '__main__':
    app = QtGui.QApplication(sys.argv)
    view = QtDeclarative.QDeclarativeView()
    view.setResizeMode(QtDeclarative.QDeclarativeView.SizeRootObjectToView)
    rc = view.rootContext()
    mainClass = PyToQml(rc)
    view.mainClass = mainClass 
    view.setSource('List.qml')
    view.show()
    sys.exit(app.exec_())
