#!/bin/sh

cd MainWindow
qmake -spec macx-g++
make clean
make
cd ..

cd hybridpy

QTGUI_INC=/Library/Frameworks/QtGui.framework/Versions/4/Headers
QTCORE_INC=/Library/Frameworks/QtCore.framework/Versions/4/Headers
QTTYPESYSTEM=/usr/share/PySide/typesystems

echo "generatorrunner ---------------------------------------------------------------------------------"    
generatorrunner --generator-set=/usr/lib/generatorrunner/shiboken_generator.dylib \
    --include-paths=../data:../MainWindow:$QTCORE_INC:$QTGUI_INC:/usr/include \
    --typesystem-paths=../data:$QTTYPESYSTEM \
    --output-directory=. \
    ../data/global.h \
    typesystem.xml 
    
echo "end generatorrunner ---------------------------------------------------------------------------------"    
    
qmake -spec macx-g++
make clean
make
cd ..

ln -sf hybridpy/libPyHybrid.dylib PyHybrid.so
ln -sf MainWindow/libMainWindow.dylib .

python Main.py