from tables import *

NEVENTS = 20000
MAX_PARTICLES_PER_EVENT = 100

class Event(IsDescription):
    _v_flavor    = "numpy"
    event_id     = IntCol(pos=0, indexed=True)

#    decay_string = StringCol(50)
    r2		 = FloatCol(pos=1)
    eventCMS	 = FloatCol(shape=4, pos=2)
    
class Baryon(IsDescription):
    _v_flavor = "numpy"
    uid		     = IntCol()
    mass	     = FloatCol()
    chi2	     = FloatCol()
    nDOF	     = IntCol()
    decayLength      = FloatCol()
    decayLengthError = FloatCol()
    decayVector      = FloatCol(shape=3)


class Gamma(IsDescription):
    _v_flavor = "numpy"
    uid = IntCol()
    momentum    = FloatCol(shape=3)
    minNeutralDistance = FloatCol()
    minTrackDistance = FloatCol()
    minTrackDtheta = FloatCol()
    bestEtaMass	= FloatCol()
    bestPi0Mass	= FloatCol()
    cmsEnergy	= FloatCol()
    labEnergy	= FloatCol()

 # Particle description
class B_Candidate(IsDescription):
    _v_flavor   = "numpy"
    event_id    = IntCol(pos=0, indexed=True) # event id (indexed)
    momentum    = FloatCol(shape=3, pos=1)    # momentum of the particle
    mass        = FloatCol(pos=2)             # mass of the particle
    uid		= IntCol(pos=3)
    chi2	= FloatCol(pos=4)
    nDOF	= IntCol(pos=5)
    legendreRatio = FloatCol(pos=6)
    decayLength = FloatCol(pos=7)
    decayLengthError = FloatCol(pos=8)
    decayVector = FloatCol(shape=3, pos=9)
    mES		= FloatCol(pos=10)
    mMiss	= FloatCol(pos=11)
    deltaE	= FloatCol(pos=12)
    gamma       = Gamma()
    baryon1	= Baryon()
    baryon2	= Baryon()


