 # -*- coding: utf-8 -*-
import sys
from PyQt4 import QtCore, QtGui
from binarigui import Ui_Form

class Principal(QtGui.QWidget):
    def __init__(self):
        QtGui.QWidget.__init__(self)

        self.finestra = Ui_Form()
        self.finestra.setupUi(self)

        self.connect(self.finestra.bdecimalabinari, QtCore.SIGNAL("clicked()"), self.decimalabinari)
        self.connect(self.finestra.bbinariadecimal, QtCore.SIGNAL("clicked()"), self.binariadecimal)

    def decimalabinari(self):
        self.nombre = str(self.finestra.textbox.text())
        self.answer = ""
        self.error = ""
        if self.nombre.isdigit():
            self.nombre = int(self.nombre)
            self.finestra.label_error.setText("")
            if self.nombre == 0:
                self.answer = '0'
            elif self.nombre == 1:
                self.answer = '1'
            else:
                while self.nombre > 0:
                    self.answer = self.answer + str(self.nombre % 2)
                    self.nombre = self.nombre // 2
                self.answer = self.answer[::-1]
                while self.answer[0] == '0':
                    self.answer = self.answer[1:]
            self.finestra.label_answer.setText(self.answer)
        else:
            self.finestra.label_error.setText("Només s'han d'introduir nombres.")

    def binariadecimal(self):
        self.nombre = str(self.finestra.textbox.text())
        self.answer = int()
        self.error = ""
        if self.nombre.isdigit():
            self.index2 = len(self.nombre) - 1
            self.finestra.label_error.setText("")
            self.index = int(-1)
            for x in self.nombre:
                self.index = self.index + 1
            for y in self.nombre:
                self.answer = self.answer + (int(y) * (2**self.index))
                self.index = self.index - 1
            self.answer = str(self.answer)
            while self.index2 >=1:
                if self.nombre[self.index2] == '0' or self.nombre[self.index2] == '1':
                    self.index2 = self.index2 - 1
                else:
                    self.finestra.label_error.setText("Els binaris només contenen 0 i 1.")
                    self.answer = str("")
                    break
            self.finestra.label_answer.setText(self.answer)


        else:
            self.finestra.label_error.setText("Només ha d'introduir nombres.'")

def main():
    app = QtGui.QApplication(sys.argv)
    finestra = Principal()
    finestra.show()
    sys.exit(app.exec_())

if __name__ == "__main__":
    main()