# This module monkey-patches the distutils package. 
#
# Features:
# 1. Makes 'LDSHARED' and 'BLDSHARED' save to use with multiple installed 
#    python frameworks
# 2. Change default install location for include-files to 
#    /Library/Python/2.3/additional-files/include
# 3. Change default install location for scripts to 
#    /Library/Python/2.3/additional-files/bin or /usr/local/bin
# 
# TODO:
# - OS and python  release independence
# - Check if this works with pyrex
# - Write documentation, and try to get features 2 and 3 into the std
#   distribution...
# 
# NOTE: This module is a crude hack and should not be regarded as good
# programming practice. It's just a way to modify a system-provided install
# of python without actually modifying files in /System.
# 
import os
_fn = os.path.join(os.path.dirname(os.__file__), 'distutils')
__path__.append(_fn)
_fn = os.path.join(_fn, '__init__.py')
del os


execfile(_fn)

del _fn

def _patch_distutils():
    import sysconfig

    vars = sysconfig.get_config_vars()
    ldshared = vars['LDSHARED']

    # XXX: Should make sure these changes make sense!
    vars['LDSHARED'] = 'env MACOSX_DEPLOYMENT_TARGET=10.3 %(CC)s %(LDFLAGS)s -bundle -undefined dynamic_lookup'%(vars)
    vars['BLDSHARED'] = 'env MACOSX_DEPLOYMENT_TARGET=10.3 %(CC)s %(LDFLAGS)s -bundle -undefined dynamic_lookup'%(vars)

    import command.install as install_cmd

    # Change the default installation directories for include-files and scripts
    install_cmd.INSTALL_SCHEMES['unix_prefix']['headers'] = (
            '/Library/Python/2.3/additional-files/include'
    )
    install_cmd.INSTALL_SCHEMES['unix_prefix']['scripts'] = (
            '/Library/Python/2.3/additional-files/bin'
    )

    # And make sure the include-dirs will be used...
    import command.build_ext as buildext_cmd
    real_finalizer = buildext_cmd.build_ext.finalize_options
    def finalize_options(self):
        real_finalizer(self)
        self.include_dirs.append('/Library/Python/2.3/additional-files/include')
    buildext_cmd.build_ext.finalize_options = finalize_options


globals().pop('_patch_distutils')()
