"""
Dummy setup.py for the distutils hack
"""
import os, sys, shutil

INSTALL_PREFIX="/Library/Python/%d.%d"%(sys.version_info[:2])

def main():
    if len(sys.argv) == 1 or sys.argv[1] != 'install':
        sys.stderr.write("Usage: python setup.py install\n")
        sys.exit(1)

    # TODO: Do we need more checks?
    
    install_dir = os.path.join(INSTALL_PREFIX, "distutils-hack")
    if os.path.isdir(install_dir):
        shutil.rmtree(install_dir)

    os.mkdir(install_dir)
    os.mkdir(os.path.join(install_dir, "distutils"))
    data = open(os.path.join(os.path.dirname(__file__), 
        'distutils', '__init__.py'), 'rb').read()
    open(os.path.join(install_dir, 'distutils', '__init__.py'), 'wb').write(data)
    
    pth_file = os.path.join(INSTALL_PREFIX, 'distutils_hack.pth')
    fp = open(pth_file, 'w')
    fp.write('import sys; sys.path.insert(0, %r)\n'%(install_dir,))
    fp.close()

    if not os.path.exists(os.path.join(INSTALL_PREFIX, 'additional-files')):
        os.mkdir(os.path.join(INSTALL_PREFIX, 'additional-files'))
        os.mkdir(os.path.join(INSTALL_PREFIX, 'additional-files', 'bin'))
        os.mkdir(os.path.join(INSTALL_PREFIX, 'additional-files', 'include'))

    print "Done"

if __name__ == "__main__":
    main()
