// Hopefully demonstrates how Remote Tables can be used present large
// and remote data sets

// Note how slow scrolling largely marks the 2s latency using caching
// and read-ahead

qx.Class.define("example.Application",
{
    extend : qx.application.Gui,

    members :
    {
        main : function(e)
        {
            this.base(arguments);

            // Create a Model which inherits from the Remote Model
            // whose task is to retrieve data
            var table_model = new example.RemoteTableModel();

            // Set the column names and aliases in the model
            table_model.setColumns(["Number",
                                    "Squared",
                                    "Cubed"],
                                   ["n",
                                    "squared",
                                    "cubed"]);
            
            // Create the table

            var table = new qx.ui.table.Table(table_model);
            table.set ({width: 'auto', height: '100%',
		        statusBarVisible: false});
            
            var tablecolumnmodel = table.getTableColumnModel ();
            
            tablecolumnmodel.setColumnWidth (0, 100);
            tablecolumnmodel.setColumnWidth (1, 125);
            tablecolumnmodel.setColumnWidth (2, 150);
            
            table.addToDocument ();
        }
    }
});
