qx.Class.define("example.RemoteTableModel",
{
    // Your base class may be qx.ui.table.RemoteTableModel
    extend : qx.ui.table.model.Remote,

        construct : function()
        {
            this.base(arguments);
        },

        members :
            {
                // This function is called to return the number of rows
                _loadRowCount: function ()
                    {
			// We don't really *need* this _data code for
			// the example, but it's probably more typical
			// of a real application

                        if (!this._data)
                            {
                                this._data = [];

                                for (var i = 0 ; i <= 1000000 ; i++)
                                    this._data.push (i);
                            }

                        this._rowCount = this._data.length;
                    },


                // This function is responsible for fetching data
                _loadRowData : function(firstRow, lastRow)
                    {
                        this.info ('Load remote row data for ' +
				   firstRow + ' to ' + lastRow);

                        // Simulate a slow 2s asynchronous round-trip
                        // to a server. Call _onRowDataLoaded when the
                        // data is ready
                        qx.client.Timer.once (function ()
                        {
                            var result = [];

                            for (var i = firstRow ; i <= lastRow ; i++)
                                {
				    // Fetch the row id for processing
				    var v = this._data[i];

                                    result.push ({n:       v,
                                                  squared: v*v,
                                                  cubed:   v*v*v});
                                }

                            this.info ('Data retrieved');
                            this._onRowDataLoaded (result);
                        }, this, 2000);

                    }
            }
});
