/* ************************************************************************

   Copyright:

   License:

   Authors:

************************************************************************ */

/* ************************************************************************

#asset(app/*)

************************************************************************ */

/**
 * This is the main application class of your custom application "app"
 */
qx.Class.define("app.Application",
{
  extend : qx.application.Standalone,



  /*
  *****************************************************************************
     MEMBERS
  *****************************************************************************
  */

  members :
  {
    /**
     * This method contains the initial application code and gets called 
     * during startup of the application
     * 
     * @lint ignoreDeprecated(alert)
     */
    main : function()
    {
      // Call super class
      this.base(arguments);

      // Enable logging in debug variant
      if (qx.core.Variant.isSet("qx.debug", "on"))
      {
        // support native logging capabilities, e.g. Firebug for Firefox
        qx.log.appender.Native;
        // support additional cross-browser console. Press F7 to toggle visibility
        qx.log.appender.Console;
      }

      /*
      -------------------------------------------------------------------------
        Below is your actual application code...
      -------------------------------------------------------------------------
      */

      var selectBox = new qx.ui.form.SelectBox;
      selectBox.add(new qx.ui.form.ListItem(this.tr("English"), null, "en"));
      selectBox.add(new qx.ui.form.ListItem(this.tr("German"),  null, "de"));
      selectBox.add(new qx.ui.form.ListItem(this.tr("French"),  null, "fr"));
      selectBox.add(new qx.ui.form.ListItem(this.tr("Italian"), null, "it"));

      selectBox.addListener("changeSelection", function (e)
      {
        var locale = e.getData()[0].getModel();
        qx.locale.Manager.getInstance().setLocale(locale);
      }, this);

      var label = new qx.ui.basic.Label(this.tr("Hello World!"));


      var doc = this.getRoot();
      doc.add(selectBox, {left: 10, top: 50});
      doc.add(label,     {left: 10, top: 80});
    }
  }
});
