/* ************************************************************************

   Copyright:

   License:

   Authors:

************************************************************************ */

/**
 * This is the main application class of your custom application "vlistest"
 *
 * @asset(vlistest/*)
 */
qx.Class.define("vlistest.Application",
{
  extend : qx.application.Standalone,



  /*
  *****************************************************************************
     MEMBERS
  *****************************************************************************
  */

  members :
  {
    /**
     * This method contains the initial application code and gets called 
     * during startup of the application
     * 
     * @lint ignoreDeprecated(alert)
     */
    main : function()
    {
      // Call super class
      this.base(arguments);

      // Enable logging in debug variant
      if (qx.core.Environment.get("qx.debug"))
      {
        // support native logging capabilities, e.g. Firebug for Firefox
        qx.log.appender.Native;
        // support additional cross-browser console. Press F7 to toggle visibility
        qx.log.appender.Console;
      }

      /*
      -------------------------------------------------------------------------
        Below is your actual application code...
      -------------------------------------------------------------------------
      */

      // Create a button
      var rawData = [];
      for (var i = 0; i < 100000; i++)
      {
        rawData[i] = {
          label: "Item No " + i,
          icon:  "16"
        }
      }
      var model = qx.data.marshal.Json.createModel(rawData);

      // Creates the list and configures it
      var list = this.__configList = new qx.ui.list.List(model).set({
        scrollbarX: "on",
        selectionMode : "one",
        height: 400,
        width: 150,
        labelPath: "label",
        iconPath: "icon",
        iconOptions: {converter : function(data) {
          return "http://demo.qooxdoo.org/current/demobrowser/resource/qx/icon/Tango/" + data + "/places/folder.png";
        }}
      });


      var that = this;

      this.getRoot().add(list);

      var btn1 = new qx.ui.form.Button("add new one and scroll");
      this.getRoot().add(btn1, {top : 350, left : 200});
      btn1.addListener("execute", function() {
        
        model.push(qx.data.marshal.Json.createModel({
          label: "LastONE",
          icon: 16
        }));
        

          list.getChildControl("pane").scrollRowIntoView(model.getLength()-1);
         
      }, this);

      // Add button to document at fixed coordinates
    }
  }
});
