from glob import iglob
from time import sleep
from pathlib import Path
from random import choice
from subprocess import call
from threading import Thread
from os.path import expanduser

from libqtile import hook

from rules import Rules
from groups import Groups
from screens import Screens
from monitors import Monitors
from bindings import Keys, Mouses
from scratchpad import Scratchpad, DropDown_Keys
from aesthetics import Layout_Aesthetics, Widget_Aesthetics, Extension_Aesthetics

def get_files():
    background_path = expanduser("~/.background")

    patterns = ['**/*.jpg']

    files = []
    for i in patterns:
        search_string = str(Path(background_path).joinpath(i))
        files.extend([f for f in iglob(search_string, recursive=True)])
    return files

def wallpaper():
    while True:
        call(["feh", "--bg-fill", choice(get_files())])
        sleep(300)

##### INIT #####

if __name__ in ["config", "__main__"]:

    num_monitors = Monitors().num_monitors()

    # Init objects
    obj_keys = Keys()
    obj_mouse_touch = Mouses()
    obj_groups = Groups()
    obj_scratchpad = Scratchpad()
    obj_dd_keys = DropDown_Keys()

    obj_rules = Rules()

    obj_widget_aesthetics = Widget_Aesthetics()
    obj_layout_aesthetics = Layout_Aesthetics()

    # Init qtile variables
    keys = obj_keys.init_keys()
    mouse = obj_mouse_touch.init_mouse()

    groups = obj_groups.init_groups()
    groups_app_rules = obj_rules.init_rules()

    if num_monitors == 1:
        print("Found one monitor")
        screens = Screens().init_mono_screen_single_bar()
    elif num_monitors == 2:
        print("Found two monitors")
        screens = Screens().init_dual_screen_single_bar()

    widget_defaults = obj_widget_aesthetics.widget_defaults

    # Append
    keys += obj_keys.init_group_keybindings(groups)
    groups += obj_scratchpad.init_scratchpad()
    keys += obj_dd_keys.init_dropdown_keybindings()

    # Constant
    cursor_warp = False
    auto_fullscreen = False
    bring_front_click = False
    follow_mouse_focus = True
    focus_on_window_activation = "smart"

    # Needed for some Java programs
    wmname = "LG3D"

@hook.subscribe.startup
def startup():

    config_dir = expanduser("~/.screenlayout")
    dual_screen_script = Path(config_dir).joinpath("dual_screen.sh")
    
    if Monitors().num_monitors() == 2:
        if dual_screen_script.exists():
            call([str(dual_screen_script)])

    Thread(target=wallpaper).start()
