import re

from libqtile.config import Group, Match
from libqtile.layout.stack import Stack
from libqtile.layout.tile import Tile
from libqtile.layout.matrix import Matrix

from layouts import Layouts

class Groups(object):

	##### GROUPS #####

	def init_groups(self):

		layout = Layouts()

		return [
			Group("Main",
				layouts = [
                    layout.max(),
					layout.monadWide()
				],
				matches = [
					Match(wm_class = [
						"Subl3",
						"Howl",
						"Geany"
					])
				]
			),
            Group("Doc",
				layouts = [
                    layout.max(),
					layout.monadWide()
				],
				matches = [
					Match(wm_instance_class = 
						["retext", "vym"]
					)
				]
			),

			Group("WWW",
				layouts = [
					layout.max(),
                    Matrix(),
                    Tile()
				],
				matches = [
					Match(wm_class = [
						"Tor Browser",
						"firefox",
						"Firefox-esr",
						"qutebrowser",
						"Chromium",
						"Links"
					]),
					Match(title = ["Links"])
				]
			),
            Group("Photo",
				layouts = [
                    layout.max(),
                    layout.floating(),
					layout.monadWide()
				],
				matches = [
					Match(wm_instance_class = [
						"gimp-2.10",
					])
				]
			),
            Group("ZAP",
				layouts = [
                    layout.floating(),
                    layout.max(),
				],
				matches = [
					Match(wm_class = [
						"install4j-burp-StartBurp",
                        "OWASP ZAP",
					])
				]
			),
            Group("OBS",
				layouts = [
                    layout.max(),
                    layout.floating(),
				],
				matches = [
					Match(wm_class = [
						"obs",
					])
				]
			),
	
        ]
# vim: tabstop=4 shiftwidth=4 noexpandtab
