#!/usr/bin/python3
from Xlib.display import Display


class Monitors(object):

    def num_monitors(self):
        
        # Get resources from the display
        d = Display()
        r = Display().screen().root
        res = r.xrandr_get_screen_resources()._data

        # Count the number of screens
        num_screens = 0
        for output in res['outputs']:
            print("Output %d:" % (output))
            mon = d.xrandr_get_output_info(output, res['config_timestamp'])._data
            print("%s: %d" % (mon['name'], mon['num_preferred']))
            if mon['num_preferred']:
                num_screens += 1

        
        return num_screens


if __name__ == "__main__":
    ns = Monitors().num_monitors()
    print(ns)
