from os import environ
from pathlib import Path

from libqtile.config import ScratchPad, DropDown, Key
from libqtile.command import lazy

class Scratchpad(object):

	def init_scratchpad(self):

		# Terminal
		terminal = '/usr/bin/urxvt'

		# Configuration
		height =				0.4650
		y_position =			0.0151
		warp_pointer =			False
		on_focus_lost_hide =	True
		opacity =				1

		return [
			ScratchPad("SPD",
				dropdowns = [
                    # Another terminal exclusively for htb vpn connection 
					DropDown("htb",
					    "/usr/bin/xterm -e /usr/sbin/openvpn /root/doorway87373.ovpn", 	
						opacity = opacity,
						y = y_position,
						height = height,
						on_focus_lost_hide = on_focus_lost_hide,
						warp_pointer = warp_pointer),
                    DropDown("term",
					    terminal,
						opacity = opacity,
						y = y_position,
						height = height,
						on_focus_lost_hide = on_focus_lost_hide,
						warp_pointer = warp_pointer)
				]
			),
		]

class DropDown_Keys(object):

	##### DROPDOWNS KEYBINDINGS #####

	def init_dropdown_keybindings(self):

		# Key alias
		mod =	"mod4"

		return [
			Key([mod], "semicolon",
				lazy.group["SPD"].dropdown_toggle("htb")),
			Key([mod], "period",
				lazy.group["SPD"].dropdown_toggle("term")),
		]

# vim: tabstop=4 shiftwidth=4 noexpandtab
