# from os.path import expanduser

from libqtile.widget import (
	GroupBox,
	Prompt,
	WindowName,
	TextBox,
	CurrentLayout,
	# CurrentLayoutIcon,
	CheckUpdates,
	Systray,
	# CapsNumLockIndicator,
	TaskList,
	# Battery,
	ThermalSensor,
	Memory,
	Clock
)

from widget.ip import NetIP 
from widgets import Pipe_Widgets as Separator_Widgets
# from widgets import Colon_Widgets as Separator_Widgets
from widgets import Space_Widgets
from aesthetics import Colors, Fonts

class Widgets_List(object):

	color = Colors()
	font = Fonts()

	space = Space_Widgets()
	separator = Separator_Widgets()

	##### WIDGETS LIST #####

	def init_top_single(self, tray = True, font = 12):

		wl  = []

		wl += [self.space.large_grey()]

		wl += [GroupBox(
			font = self.font.bold,
			fontsize = font,
			margin_y = 0,
			margin_x = 0,
			# padding_y = 6,
			padding_x = 3,
			borderwidth = 2,
			# hide_unused = True,
			active = self.color.white,
			inactive = self.color.lightgrey,
			urgent_text = self.color.white,
			highlight_method = "line",
			highlight_color = ["2B303B", "14161B"],
			urgent_alert_method = "line",
			rounded = False,
			urgent_border = self.color.red,
			this_current_screen_border = self.color.blue,
			other_screen_border = self.color.magenta,
			this_screen_border = self.color.orange,
			other_current_screen_border = self.color.magenta,
			disable_drag = True,
			use_mouse_wheel = False
		)]

		wl += [Prompt(
			prompt = "λ : ",
			padding = 5,
			bell_style = "visual",
			foreground = self.color.magenta,
			background = self.color.black
		)]

		wl += [self.space.large_grey()]

		wl += [WindowName(
			fontsize = font,
			padding = 0,
			show_state = False,
			foreground = self.color.darkgreen
		)]

		wl += [self.space.large_grey()]

		wl += [NetIP()]

		wl += [self.separator.bold_white()]

		wl += [CurrentLayout()]

		#wl += [self.separator.bold_white()]

		if tray:
			wl += [self.separator.bold_white()]
			wl += [Systray(
				padding = 3,
				icon_size = 19
			)]

		#wl += [self.separator.bold_white()]

		wl += [Clock(
			format = "%a, %b %d - %H:%M"
		)]
		wl += [self.space.large_grey()]

		return wl

	def init_top_double(self, tray = True, font = 12):

		wl  = []

		wl += [self.space.large_grey()]
		wl += [GroupBox(
			font = self.font.bold,
			fontsize = font,
			margin_y = 0,
			margin_x = 0,
			# padding_y = 6,
			padding_x = 3,
			borderwidth = 2,
			# hide_unused = True,
			active = self.color.white,
			inactive = self.color.lightgrey,
			urgent_text = self.color.white,
			highlight_method = "line",
			highlight_color = ["2B303B", "14161B"],
			urgent_alert_method = "line",
			rounded = False,
			urgent_border = self.color.red,
			this_current_screen_border = self.color.blue,
			other_screen_border = self.color.magenta,
			this_screen_border = self.color.orange,
			other_current_screen_border = self.color.magenta,
			disable_drag = True,
			use_mouse_wheel = False
		)]

		wl += [Prompt(
			prompt = "λ : ",
			padding = 5,
			bell_style = "visual",
			foreground = self.color.magenta,
			background = self.color.black
		)]

		wl += [self.space.large_grey()]

		wl += [WindowName(
			fontsize = font,
			padding = 0,
			show_state = False,
			foreground = self.color.darkgreen
		)]

		wl += [self.space.large_grey()]

		wl += [TextBox(
			fontsize = font,
			text = ""
		)]

		wl += [NetIP()]

		if tray:
			wl += [self.separator.bold_white()]
			wl += [Systray(
				padding = 3,
				icon_size = 19
			)]
		# if not tray:
		# 	wl += [self.separator.bold_white()]
		# wl += [CurrentLayoutIcon(
		# 	padding = 0,
		# 	custom_icon_paths = [expanduser("~/.config/qtile/icons")],
		# 	scale = 0.6
		# )]
		wl += [self.space.large_grey()]

		return wl

	def init_bottom_double(self, font = 12):

		wl  = []

		wl += [self.space.large_grey()]
		wl += [TaskList(
			fontsize = font,
			margin_x = 0,
			margin_y = 1,
			padding_x = 3,
			padding_y = 2.3,
			borderwidth = 1,
			# icon_size = 14,
			icon_size = 0,
			spacing = 1,
			# max_title_width = 190,
			title_width_method = 'uniform',
			urgent_alert_method = "text",
			highlight_method = "block",
			txt_minimized = "V ",
			txt_maximized = "",
			txt_floating = "",
			# unfocused_border = "None",
			rounded = True,
			border = self.color.grey
		)]
		wl += [self.space.large_grey()]

		wl += [TextBox(
			text = ""
		)]
		wl += [self.separator.bold_white()]

		wl += [self.separator.bold_white()]
		wl += [TextBox(
			font = self.font.bold,
			text = ""
		)]
		wl += [self.separator.bold_white()]
		wl += [TextBox(
			font = self.font.bold,
			text = ""
		)]
		wl += [CurrentLayout()]

		wl += [self.separator.bold_white()]
		wl += [TextBox(
			font = self.font.bold,
			text = ""
		)]
		wl += [self.separator.bold_white()]
		wl += [TextBox(
			font = self.font.bold,
			text = ""
		)]
		wl += [Clock(
			format = "%a, %b %d - %H:%M"
		)]
		wl += [self.space.large_grey()]

		return wl

# vim: tabstop=4 shiftwidth=4 noexpandtab
