#!/usr/bin/env python
# -*- coding: utf-8 -*-

import re
import sys
import os
import numpy as np
from collections import defaultdict

sys.path.append('/opt/rdkit-Release_2016_03_2/')
from rdkit import Chem
from rdkit.Chem import AllChem, SanitizeMol
from rdkit.Chem import SDMolSupplier, SDWriter
from rdkit.Chem import MolFromMol2File, RemoveHs

def getCoords(ligand):
    coords=[]
    for i in range(0, ligand.GetNumAtoms()):
       pos = ligand.GetConformer().GetAtomPosition(i)
       coords.append(pos)
    return coords

def rmsd(coord1, coord2):
    r=0
    try:
        r=np.sqrt( np.sum((np.array(coord1)-np.array(coord2))**2)/len(coord1))
    except:
        pass

    return r

def main():
    ref_gal = Chem.MolFromPDBFile(sys.argv[1])
    Chem.AssignAtomChiralTagsFromStructure(ref_gal)
    galcoords=getCoords(ref_gal)

    try:
        poses=open(sys.argv[2],'r')
    except:
        print "Unable to read %s" % sys.argv[2]
        exit
    suppl = SDMolSupplier(sys.argv[2]) 

    i=0
    for l in suppl:
        Chem.AssignAtomChiralTagsFromStructure(l,replaceExistingTags=True)
        i=i+1
        nom='mol'+str(i)
        try:
            nom=l.GetProp('_Name')
        except:
            pass

        # first get all the atom coordinates from substructure match using chirality otherwise it won't work
        m=l.GetSubstructMatches(ref_gal,useChirality=True)
#        print m

        l_coords=[]

        if m:
            for a in m[0]:
               l_coords.append(l.GetConformer().GetAtomPosition(a))

        # Second compute the rmsd to the reference ligand
        r=rmsd(galcoords,l_coords)
        try:
            print "%s %s %s %f" % (sys.argv[1], sys.argv[2], nom, r)
        except Exception as e:
            print "%s: unable to compute the rmsd (error: %s)" % (nom,e)
            pass

if __name__ == "__main__":
    main()
