package test.org.apache.regexp;

/*
 * ====================================================================
 * 
 * The Apache Software License, Version 1.1
 * 
 * Copyright (c) 1999 The Apache Software Foundation.  All rights
 * reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in
 * the documentation and/or other materials provided with the
 * distribution.
 * 
 * 3. The end-user documentation included with the redistribution, if
 * any, must include the following acknowlegement:
 * "This product includes software developed by the
 * Apache Software Foundation (http://www.apache.org/)."
 * Alternately, this acknowlegement may appear in the software itself,
 * if and wherever such third-party acknowlegements normally appear.
 * 
 * 4. The names "The Jakarta Project", "Jakarta-Regexp", and "Apache Software
 * Foundation" must not be used to endorse or promote products derived
 * from this software without prior written permission. For written
 * permission, please contact apache@apache.org.
 * 
 * 5. Products derived from this software may not be called "Apache"
 * nor may "Apache" appear in their names without prior written
 * permission of the Apache Group.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 * 
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 * 
 */

import java.io.*;
import org.apache.regexp.*;

/**
 * Interactive tester for <code>RE.match()</code>.
 * 
 * @author <a href="mailto:pholser@mindspring.com">Paul Holser</a>
 */

public class InteractiveREMatchTest
{
/**
 * Main program entrypoint.  Lines of input from the keyboard are
 * matched in turn against the regular expression pattern given on the
 * command line, and the results displayed.
 * 
 * @param  args  Command line arguments.  Expecting only one argument:
 * the regular expression pattern to match against.
 */

public static void main(String[] args)
{
	if (args.length < 1)
	{
		System.err.println("usage: InteractiveREMatchTest <pattern>");
		return;
	}

	try
	{
		test(args[0]);
	}
	catch (Exception e)
	{
		e.printStackTrace();
	}
}


/**
 * Compile and test matching against a single expression.
 * 
 * @param  expr  Pattern to compile and test
 * @exception  Exception  if something goes wronga
 */

private static void test(String expr) throws Exception
{
	RE re = new RE();
	REDebugCompiler compiler = new REDebugCompiler();

	re.setProgram(compiler.compile(expr));
	System.out.println("\nMatching against pattern: " + expr);

	compiler.dumpProgram(new PrintWriter(System.out));

	while (true)
	{
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

		System.out.print("> ");
		System.out.flush();

		String targetText = br.readLine();

		System.out.println(re.match(targetText) ? "Matched" : "Did not match");

		showParens(re);
	}
}


/**
 * Dump parenthesized subexpressions found by a regular expression
 * matcher object.
 * 
 * @param  re  Matcher object with results to show
 */

private static void showParens(RE re)
{
	for (int i = 0; i < re.getParenCount(); ++i)
	{
		System.out.println("$" + i + " = " + re.getParen(i));
	}
}

}