package test.org.apache.regexp;

/*
 * ====================================================================
 * 
 * The Apache Software License, Version 1.1
 * 
 * Copyright (c) 1999 The Apache Software Foundation.  All rights
 * reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in
 * the documentation and/or other materials provided with the
 * distribution.
 * 
 * 3. The end-user documentation included with the redistribution, if
 * any, must include the following acknowlegement:
 * "This product includes software developed by the
 * Apache Software Foundation (http://www.apache.org/)."
 * Alternately, this acknowlegement may appear in the software itself,
 * if and wherever such third-party acknowlegements normally appear.
 * 
 * 4. The names "The Jakarta Project", "Jakarta-Regexp", and "Apache Software
 * Foundation" must not be used to endorse or promote products derived
 * from this software without prior written permission. For written
 * permission, please contact apache@apache.org.
 * 
 * 5. Products derived from this software may not be called "Apache"
 * nor may "Apache" appear in their names without prior written
 * permission of the Apache Group.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 * 
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 * 
 */

import java.io.*;
import junit.framework.*;
import org.apache.regexp.*;

/**
 * JUnit tests for the <code>RE</code> class.
 *
 * @author <a href="mailto:pholser@mindspring.com">Paul Holser</a>
 */

public class RETest extends TestCase
{
  private REDebugCompiler compiler;
  private char[] preAStarBInstructions;
  private REProgram preAStarBProgram;
  private RE preAStarB;
  private RE aStarB;
  private RE xPlus;

public RETest(String name)
{
	super(name);
}

public void setUp() throws Exception
{
	super.setUp();

	compiler = new REDebugCompiler();

	// Pre-compiled regular expression "a*b"
	preAStarBInstructions = 
		new char[] {
			0x007c, 
			0x0000, 
			0x001a, 
			0x007c, 
			0x0000, 
			0x000d, 
			0x0041, 
			0x0001, 
			0x0004, 
			0x0061, 
			0x007c, 
			0x0000, 
			0x0003, 
			0x0047, 
			0x0000, 
			0xfff6, 
			0x007c, 
			0x0000, 
			0x0003, 
			0x004e, 
			0x0000, 
			0x0003, 
			0x0041, 
			0x0001, 
			0x0004, 
			0x0062, 
			0x0045, 
			0x0000, 
			0x0000, 
			}; 

	preAStarBProgram = new REProgram(preAStarBInstructions);
	preAStarB = new RE(preAStarBProgram);

	try
	{
		aStarB = new RE("a*b");
		xPlus = new RE("x+");
	}
	catch (RESyntaxException e)
	{
		fail("Couldn't construct an RE: " + e.getMessage());
	}
}

public static void main(String[] args)
{
	new junit.swingui.TestRunner().run(RETest.class);
}

public static Test suite()
{
	return new TestSuite(RETest.class);
}

public void testPreCompiledRegexpAStarB()
{
	assert("aaab should match a*b", preAStarB.match("aaab"));
	assert("b should match a*b", preAStarB.match("b"));
	assert("c should not match a*b", ! preAStarB.match("c"));
	assert("ccccaaaaab should match a*b", preAStarB.match("ccccaaaaab"));
}

public void testGreppingForResultsOfSplitAStarB()
{
	String[] pieces = aStarB.split("xxxxaabxxxxbyyyyaaabzzz");
	String[] piecesMatch = xPlus.grep(pieces);
	assertEquals(2, piecesMatch.length);
	assertEquals("xxxx", piecesMatch[0]);
	assertEquals("xxxx", piecesMatch[1]);
}

public void testSubstUsingAStarB()
{
	String s = aStarB.subst("aaaabfooaaabgarplyaaabwackyb", "-");
	assertEquals("-foo-garply-wacky-", s);
}

}