/*
 *  arch-tag: Album-Cover Widget for the Header
 *
 *  Copyright (C) 2004 Joergen Scheibengruber <mfcn@gmx.de>
 *  Copyright (C) 2004,2005 Marc Pavot <m.pavot@laposte.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <gtk/gtkeventbox.h>
#include "rhythmdb.h"
#include "rb-source.h"


#ifndef __RB_ALBUM_COVER_H
#define __RB_ALBUM_COVER_H

G_BEGIN_DECLS

#define RB_TYPE_ALBUM_COVER         (rb_album_cover_get_type ())
#define RB_ALBUM_COVER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), RB_TYPE_ALBUM_COVER, RBAlbumCover))
#define RB_ALBUM_COVER_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), RB_TYPE_ALBUM_COVER, RBAlbumCoverClass))
#define RB_IS_ALBUM_COVER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), RB_TYPE_ALBUM_COVER))
#define RB_IS_ALBUM_COVER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), RB_TYPE_ALBUM_COVER))
#define RB_ALBUM_COVER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), RB_TYPE_ALBUM_COVER, RBAlbumCoverClass))

typedef struct RBAlbumCoverPrivate RBAlbumCoverPrivate;

typedef struct
{
	GtkEventBox parent;

	RBAlbumCoverPrivate *priv;
} RBAlbumCover;

typedef struct
{
	GtkEventBoxClass parent;
} RBAlbumCoverClass;

GType			rb_album_cover_get_type				(void);

GtkWidget * 		rb_album_cover_new				(void);

void 			rb_album_cover_set_playing_entry		(RBAlbumCover *album_cover, 
		            						 RhythmDBEntry *entry);
void			rb_album_cover_set_source			(RBAlbumCover *album_cover,
									 RBSource *source);

GtkWidget * 		rb_album_cover_get_config_widget 		(RBAlbumCover *album_cover);

void			rb_album_cover_xml_loaded_cb			(GnomeVFSResult result,
                    							 GnomeVFSFileSize file_size,
                   							 char *file_contents,
                   							 gpointer callback_data);
void			rb_album_cover_uri_loaded_cb			(GnomeVFSResult result,
                   							 GnomeVFSFileSize file_size,
                   							 char *file_contents,
                   							 gpointer callback_data);

G_END_DECLS

#endif /* __RB_ALBUM_COVER_H */
